# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.local_frame_based_maneuver_sequence import LocalFrameBasedManeuverSequence
from spacetower_orbit_extrapolation_python_client.models.maneuver_schedule import ManeuverSchedule
from spacetower_orbit_extrapolation_python_client.models.maneuver_schedule_type import ManeuverScheduleType
from spacetower_orbit_extrapolation_python_client.models.rotating_local_frame_id import RotatingLocalFrameId
from typing import Optional, Set
from typing_extensions import Self

class LocalFrameBasedManeuverSchedule(ManeuverSchedule):
    """
    Maneuver schedule defined in a local frame
    """ # noqa: E501
    local_frame_id: RotatingLocalFrameId = Field(alias="localFrameId")
    local_frame_based_maneuver_sequence: Optional[LocalFrameBasedManeuverSequence] = Field(default=None, alias="localFrameBasedManeuverSequence")
    __properties: ClassVar[List[str]] = ["maneuverScheduleType", "localFrameId", "localFrameBasedManeuverSequence"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LocalFrameBasedManeuverSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of local_frame_based_maneuver_sequence
        if self.local_frame_based_maneuver_sequence:
            _dict['localFrameBasedManeuverSequence'] = self.local_frame_based_maneuver_sequence.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LocalFrameBasedManeuverSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "maneuverScheduleType": obj.get("maneuverScheduleType"),
            "localFrameId": obj.get("localFrameId"),
            "localFrameBasedManeuverSequence": LocalFrameBasedManeuverSequence.from_dict(obj["localFrameBasedManeuverSequence"]) if obj.get("localFrameBasedManeuverSequence") is not None else None
        })
        return _obj


