# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.anomaly_type import AnomalyType
from spacetower_orbit_extrapolation_python_client.models.field_description import FieldDescription
from spacetower_orbit_extrapolation_python_client.models.inertial_frame_id import InertialFrameId
from spacetower_orbit_extrapolation_python_client.models.orbital_parameter_type import OrbitalParameterType
from typing import Optional, Set
from typing_extensions import Self

class OsculatingOrbitEphemeris(BaseModel):
    """
    Ephemeris of osculating orbital elements in an inertial frame. Orbital parameters are either Keplerian, circular or equinoctial
    """ # noqa: E501
    dates: List[str] = Field(description="The UTC dates of the data points")
    description: Optional[List[FieldDescription]] = Field(default=None, description="List of each metric outputted and how to identify them in each entry (DataEntry corresponding to a date) of the data array")
    inertial_frame_id: Optional[InertialFrameId] = Field(default=None, alias="inertialFrameId")
    orbit_type: OrbitalParameterType = Field(alias="orbitType")
    anomaly_type: AnomalyType = Field(alias="anomalyType")
    data: List[List[Union[StrictFloat, StrictInt]]] = Field(description="Ephemeris data. Each entry (DataEntry) corresponds to a date, and contains the list of the computed values as presented in the description field, according to the orbit type: <br> - ``KEPLERIAN``: [[sma[m], ecc[-], inc[rad], aop[rad], raan[rad], mean/true/eccentric-an[rad]], ...]<br> - ``CIRCULAR``: [[sma[m], circular-ex[-], circular-ey[-], inc[rad], raan[rad], mean/true/eccentric-aol[rad]], ...]<br> - ``EQUINOCTIAL``: [[sma[m], equinoctial-ex[-], equinoctial-ey[-], equinoctial-ix[-], equinoctial-iy[-], mean/true/eccentric-lon[rad]], ...] ")
    __properties: ClassVar[List[str]] = ["dates", "description", "inertialFrameId", "orbitType", "anomalyType", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OsculatingOrbitEphemeris from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item in self.description:
                if _item:
                    _items.append(_item.to_dict())
            _dict['description'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OsculatingOrbitEphemeris from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dates": obj.get("dates"),
            "description": [FieldDescription.from_dict(_item) for _item in obj["description"]] if obj.get("description") is not None else None,
            "inertialFrameId": obj.get("inertialFrameId"),
            "orbitType": obj.get("orbitType"),
            "anomalyType": obj.get("anomalyType"),
            "data": obj.get("data")
        })
        return _obj


