# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.2.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.cartesian_ephemeris import CartesianEphemeris
from spacetower_orbit_extrapolation_python_client.models.celestial_relative_position_ephemeris import CelestialRelativePositionEphemeris
from spacetower_orbit_extrapolation_python_client.models.geodetic_ephemeris import GeodeticEphemeris
from spacetower_orbit_extrapolation_python_client.models.mean_orbit_ephemeris import MeanOrbitEphemeris
from spacetower_orbit_extrapolation_python_client.models.osculating_orbit_ephemeris import OsculatingOrbitEphemeris
from spacetower_orbit_extrapolation_python_client.models.secondary_relative_cartesian_ephemeris import SecondaryRelativeCartesianEphemeris
from spacetower_orbit_extrapolation_python_client.models.terrestrial_relative_position_ephemeris import TerrestrialRelativePositionEphemeris
from spacetower_orbit_extrapolation_python_client.models.tle_ephemeris import TleEphemeris
from typing import Optional, Set
from typing_extensions import Self

class Ephemeris(BaseModel):
    """
    Ephemeris
    """ # noqa: E501
    cartesian_ephemeris: Optional[CartesianEphemeris] = Field(default=None, alias="cartesianEphemeris")
    geodetic_ephemeris: Optional[GeodeticEphemeris] = Field(default=None, alias="geodeticEphemeris")
    mean_orbit_ephemeris: Optional[MeanOrbitEphemeris] = Field(default=None, alias="meanOrbitEphemeris")
    osculating_orbit_ephemeris: Optional[OsculatingOrbitEphemeris] = Field(default=None, alias="osculatingOrbitEphemeris")
    tle_ephemeris: Optional[TleEphemeris] = Field(default=None, alias="tleEphemeris")
    celestial_relative_ephemeris: Optional[CelestialRelativePositionEphemeris] = Field(default=None, alias="celestialRelativeEphemeris")
    secondary_relative_ephemeris: Optional[SecondaryRelativeCartesianEphemeris] = Field(default=None, alias="secondaryRelativeEphemeris")
    terrestrial_relative_ephemeris: Optional[TerrestrialRelativePositionEphemeris] = Field(default=None, alias="terrestrialRelativeEphemeris")
    __properties: ClassVar[List[str]] = ["cartesianEphemeris", "geodeticEphemeris", "meanOrbitEphemeris", "osculatingOrbitEphemeris", "tleEphemeris", "celestialRelativeEphemeris", "secondaryRelativeEphemeris", "terrestrialRelativeEphemeris"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Ephemeris from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cartesian_ephemeris
        if self.cartesian_ephemeris:
            _dict['cartesianEphemeris'] = self.cartesian_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of geodetic_ephemeris
        if self.geodetic_ephemeris:
            _dict['geodeticEphemeris'] = self.geodetic_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mean_orbit_ephemeris
        if self.mean_orbit_ephemeris:
            _dict['meanOrbitEphemeris'] = self.mean_orbit_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of osculating_orbit_ephemeris
        if self.osculating_orbit_ephemeris:
            _dict['osculatingOrbitEphemeris'] = self.osculating_orbit_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tle_ephemeris
        if self.tle_ephemeris:
            _dict['tleEphemeris'] = self.tle_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of celestial_relative_ephemeris
        if self.celestial_relative_ephemeris:
            _dict['celestialRelativeEphemeris'] = self.celestial_relative_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secondary_relative_ephemeris
        if self.secondary_relative_ephemeris:
            _dict['secondaryRelativeEphemeris'] = self.secondary_relative_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of terrestrial_relative_ephemeris
        if self.terrestrial_relative_ephemeris:
            _dict['terrestrialRelativeEphemeris'] = self.terrestrial_relative_ephemeris.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Ephemeris from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cartesianEphemeris": CartesianEphemeris.from_dict(obj["cartesianEphemeris"]) if obj.get("cartesianEphemeris") is not None else None,
            "geodeticEphemeris": GeodeticEphemeris.from_dict(obj["geodeticEphemeris"]) if obj.get("geodeticEphemeris") is not None else None,
            "meanOrbitEphemeris": MeanOrbitEphemeris.from_dict(obj["meanOrbitEphemeris"]) if obj.get("meanOrbitEphemeris") is not None else None,
            "osculatingOrbitEphemeris": OsculatingOrbitEphemeris.from_dict(obj["osculatingOrbitEphemeris"]) if obj.get("osculatingOrbitEphemeris") is not None else None,
            "tleEphemeris": TleEphemeris.from_dict(obj["tleEphemeris"]) if obj.get("tleEphemeris") is not None else None,
            "celestialRelativeEphemeris": CelestialRelativePositionEphemeris.from_dict(obj["celestialRelativeEphemeris"]) if obj.get("celestialRelativeEphemeris") is not None else None,
            "secondaryRelativeEphemeris": SecondaryRelativeCartesianEphemeris.from_dict(obj["secondaryRelativeEphemeris"]) if obj.get("secondaryRelativeEphemeris") is not None else None,
            "terrestrialRelativeEphemeris": TerrestrialRelativePositionEphemeris.from_dict(obj["terrestrialRelativeEphemeris"]) if obj.get("terrestrialRelativeEphemeris") is not None else None
        })
        return _obj


