# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.2.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.anomaly_type import AnomalyType
from spacetower_orbit_extrapolation_python_client.models.covariance_orbit_type import CovarianceOrbitType
from spacetower_orbit_extrapolation_python_client.models.field_description import FieldDescription
from spacetower_orbit_extrapolation_python_client.models.inertial_frame_id import InertialFrameId
from typing import Optional, Set
from typing_extensions import Self

class OrbitalCovarianceEphemeris(BaseModel):
    """
    Ephemeris of orbital covariance in an inertial frame
    """ # noqa: E501
    dates: List[str] = Field(description="The UTC dates of the data points")
    description: Optional[List[FieldDescription]] = Field(default=None, description="List of each metric outputted and how to identify them in each entry (DataEntry corresponding to a date) of the data array")
    covariance_orbit_type: Optional[CovarianceOrbitType] = Field(default=None, alias="covarianceOrbitType")
    anomaly_type: Optional[AnomalyType] = Field(default=None, alias="anomalyType")
    inertial_frame_id: Optional[InertialFrameId] = Field(default=None, alias="inertialFrameId")
    data: List[List[Union[StrictFloat, StrictInt]]] = Field(description="Ephemeris data. Each entry (DataEntry) corresponds to a date, and contains the list of the computed values as presented in the description field, according to the orbit type: <br> - ``KEPLERIAN``: [[sma-var[m^2], sma-ecc-cov[m], sma-inc-cov[m\\*rad], sma-aop-cov[m\\*rad], sma-raan-cov[m\\*rad], sma-mean/true/eccentric-an-cov[m\\*rad], <br>                            ecc-var[-],     ecc-inc-cov[rad],    ecc-aop-cov[rad],    ecc-raan-cov[rad],    ecc-mean/true/eccentric-an-cov[rad], <br>                                            inc-var[rad^2],      inc-aop-cov[rad^2],  inc-raan-cov[rad^2],  inc-mean/true/eccentric-an-cov[rad^2], <br>                                                                 aop-var[rad^2],      aop-raan-cov[rad^2],  aop-mean/true/eccentric-an-cov[rad^2], <br>                                                                                      raan-var[rad^2],      raan-mean/true/eccentric-an-cov[rad^2], <br>                                                                                                            mean/true/eccentric-an-var[rad^2]], ...]<br> - ``CIRCULAR``: [[sma-var[m^2], sma-ex-cov[m], sma-ey-cov[m], sma-inc-cov[m\\*rad], sma-raan-cov[m\\*rad], sma-mean/true/eccentric-aol-cov[m\\*rad], <br>                           ex-var[-],     ex-ey-cov[-],  ex-inc-cov[rad],     ex-raan-cov[rad],     ex-mean/true/eccentric-aol-cov[rad], <br>                                          ey-var[-],     ey-inc-cov[rad],     ey-raan-cov[rad],     ey-mean/true/eccentric-aol-cov[rad], <br>                                                         inc-var[rad^2],      inc-raan-cov[rad^2],  inc-mean/true/eccentric-aol-cov[rad^2], <br>                                                                              raan-var[rad^2],      raan-mean/true/eccentric-aol-cov[rad^2], <br>                                                                                                    mean/true/eccentric-aol-var[rad^2]], ...]<br> - ``EQUINOCTIAL``: [[sma-var[m^2], sma-ex-cov[m], sma-ey-cov[m], sma-hx-cov[m], sma-hy-cov[m], sma-mean/true/eccentric-lon-cov[m\\*rad], <br>                              ex-var[-],     ex-ey-cov[-],  ex-hx-cov[-],  ex-hy-cov[-],  ex-mean/true/eccentric-lon-cov[rad], <br>                                             ey-var[-],     ey-hx-cov[-],  ey-hy-cov[-],  ey-mean/true/eccentric-lon-cov[rad], <br>                                                            hx-var[-],     hx-hy-cov[-],  hx-mean/true/eccentric-lon-cov[rad], <br>                                                                           hy-var[-],     hy-mean/true/eccentric-lon-cov[rad], <br>                                                                                          mean/true/eccentric-lon-var[rad^2]], ...] ")
    __properties: ClassVar[List[str]] = ["dates", "description", "covarianceOrbitType", "anomalyType", "inertialFrameId", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitalCovarianceEphemeris from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item in self.description:
                if _item:
                    _items.append(_item.to_dict())
            _dict['description'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitalCovarianceEphemeris from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dates": obj.get("dates"),
            "description": [FieldDescription.from_dict(_item) for _item in obj["description"]] if obj.get("description") is not None else None,
            "covarianceOrbitType": obj.get("covarianceOrbitType"),
            "anomalyType": obj.get("anomalyType"),
            "inertialFrameId": obj.get("inertialFrameId"),
            "data": obj.get("data")
        })
        return _obj


