# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.2.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.earth_fixed_frame_id import EarthFixedFrameId
from spacetower_orbit_extrapolation_python_client.models.ellipsoid_id import EllipsoidId
from spacetower_orbit_extrapolation_python_client.models.final_orbit_configuration import FinalOrbitConfiguration
from spacetower_orbit_extrapolation_python_client.models.inertial_frame_id import InertialFrameId
from spacetower_orbit_extrapolation_python_client.models.rotating_local_frame_id import RotatingLocalFrameId
from spacetower_orbit_extrapolation_python_client.models.shadow_model_type import ShadowModelType
from typing import Optional, Set
from typing_extensions import Self

class OutputConfiguration(BaseModel):
    """
    Frame types (Earth-fixed, inertial, orbit relative) and ellipsoid model used for the output final state, ephemeris and events 
    """ # noqa: E501
    include_tidal_effects_in_eop_interpolation: Optional[StrictBool] = Field(default=False, description="Flag to include tidal effects when interpolation Earth Orientation Parameters (comes with a higher computational cost, so default is false)", alias="includeTidalEffectsInEopInterpolation")
    inertial_frame_id: Optional[InertialFrameId] = Field(default=None, alias="inertialFrameId")
    earth_fixed_frame_id: Optional[EarthFixedFrameId] = Field(default=None, alias="earthFixedFrameId")
    local_frame_id: Optional[RotatingLocalFrameId] = Field(default=None, alias="localFrameId")
    ellipsoid_id: Optional[EllipsoidId] = Field(default=None, alias="ellipsoidId")
    shadow_model_type: Optional[ShadowModelType] = Field(default=None, alias="shadowModelType")
    final_orbit_configuration: Optional[FinalOrbitConfiguration] = Field(default=None, alias="finalOrbitConfiguration")
    __properties: ClassVar[List[str]] = ["includeTidalEffectsInEopInterpolation", "inertialFrameId", "earthFixedFrameId", "localFrameId", "ellipsoidId", "shadowModelType", "finalOrbitConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OutputConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of final_orbit_configuration
        if self.final_orbit_configuration:
            _dict['finalOrbitConfiguration'] = self.final_orbit_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OutputConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "includeTidalEffectsInEopInterpolation": obj.get("includeTidalEffectsInEopInterpolation") if obj.get("includeTidalEffectsInEopInterpolation") is not None else False,
            "inertialFrameId": obj.get("inertialFrameId"),
            "earthFixedFrameId": obj.get("earthFixedFrameId"),
            "localFrameId": obj.get("localFrameId"),
            "ellipsoidId": obj.get("ellipsoidId"),
            "shadowModelType": obj.get("shadowModelType"),
            "finalOrbitConfiguration": FinalOrbitConfiguration.from_dict(obj["finalOrbitConfiguration"]) if obj.get("finalOrbitConfiguration") is not None else None
        })
        return _obj


