# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.2.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Union
from typing_extensions import Annotated
from spacetower_orbit_extrapolation_python_client.models.secondary_object_definition import SecondaryObjectDefinition
from spacetower_orbit_extrapolation_python_client.models.secondary_object_event_definition import SecondaryObjectEventDefinition
from spacetower_orbit_extrapolation_python_client.models.secondary_object_event_definition_type import SecondaryObjectEventDefinitionType
from typing import Optional, Set
from typing_extensions import Self

class RelativeDistanceDefinition(SecondaryObjectEventDefinition):
    """
    Computes crossings of critical relative distance with secondary object assuming analytical propagation i.e. Keplerian or SGP4 (need a TleOrbit for the latter)
    """ # noqa: E501
    critical_distance: Union[Annotated[float, Field(strict=True, gt=0.0)], Annotated[int, Field(strict=True, gt=0)]] = Field(alias="criticalDistance")
    __properties: ClassVar[List[str]] = ["eventDefinitionType", "secondaryObject", "criticalDistance"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RelativeDistanceDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of secondary_object
        if self.secondary_object:
            _dict['secondaryObject'] = self.secondary_object.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RelativeDistanceDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventDefinitionType": obj.get("eventDefinitionType"),
            "secondaryObject": SecondaryObjectDefinition.from_dict(obj["secondaryObject"]) if obj.get("secondaryObject") is not None else None,
            "criticalDistance": obj.get("criticalDistance")
        })
        return _obj


