# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.2.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from spacetower_orbit_extrapolation_python_client.models.reflection_absorption_coefficients import ReflectionAbsorptionCoefficients
from spacetower_orbit_extrapolation_python_client.models.vector3_d import Vector3D
from typing import Optional, Set
from typing_extensions import Self

class SolarArrayGeometry(BaseModel):
    """
    Solar array geometry with drag and reflection parameters
    """ # noqa: E501
    radiation_coefficients: Optional[ReflectionAbsorptionCoefficients] = Field(default=None, alias="radiationCoefficients")
    drag_coefficient: Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=2.2, description="Drag coefficient of the solar array panel. Units [-]", alias="dragCoefficient")
    surface_area: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="Units [m^2]", alias="surfaceArea")
    normal_axis_in_space_object_frame: Vector3D = Field(alias="normalAxisInSpaceObjectFrame")
    __properties: ClassVar[List[str]] = ["radiationCoefficients", "dragCoefficient", "surfaceArea", "normalAxisInSpaceObjectFrame"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SolarArrayGeometry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of radiation_coefficients
        if self.radiation_coefficients:
            _dict['radiationCoefficients'] = self.radiation_coefficients.to_dict()
        # override the default output from pydantic by calling `to_dict()` of normal_axis_in_space_object_frame
        if self.normal_axis_in_space_object_frame:
            _dict['normalAxisInSpaceObjectFrame'] = self.normal_axis_in_space_object_frame.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SolarArrayGeometry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "radiationCoefficients": ReflectionAbsorptionCoefficients.from_dict(obj["radiationCoefficients"]) if obj.get("radiationCoefficients") is not None else None,
            "dragCoefficient": obj.get("dragCoefficient") if obj.get("dragCoefficient") is not None else 2.2,
            "surfaceArea": obj.get("surfaceArea"),
            "normalAxisInSpaceObjectFrame": Vector3D.from_dict(obj["normalAxisInSpaceObjectFrame"]) if obj.get("normalAxisInSpaceObjectFrame") is not None else None
        })
        return _obj


