# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.attitude_ephemeris import AttitudeEphemeris
from spacetower_orbit_extrapolation_python_client.models.battery_power_ephemeris import BatteryPowerEphemeris
from spacetower_orbit_extrapolation_python_client.models.cartesian_covariance_ephemeris import CartesianCovarianceEphemeris
from spacetower_orbit_extrapolation_python_client.models.cartesian_ephemeris import CartesianEphemeris
from spacetower_orbit_extrapolation_python_client.models.celestial_relative_position_ephemeris import CelestialRelativePositionEphemeris
from spacetower_orbit_extrapolation_python_client.models.geodetic_ephemeris import GeodeticEphemeris
from spacetower_orbit_extrapolation_python_client.models.mass_ephemeris import MassEphemeris
from spacetower_orbit_extrapolation_python_client.models.mean_orbit_ephemeris import MeanOrbitEphemeris
from spacetower_orbit_extrapolation_python_client.models.orbital_covariance_ephemeris import OrbitalCovarianceEphemeris
from spacetower_orbit_extrapolation_python_client.models.osculating_orbit_ephemeris import OsculatingOrbitEphemeris
from spacetower_orbit_extrapolation_python_client.models.secondary_relative_cartesian_ephemeris import SecondaryRelativeCartesianEphemeris
from spacetower_orbit_extrapolation_python_client.models.terrestrial_relative_position_ephemeris import TerrestrialRelativePositionEphemeris
from spacetower_orbit_extrapolation_python_client.models.thrust_vector_ephemeris import ThrustVectorEphemeris
from spacetower_orbit_extrapolation_python_client.models.tle_ephemeris import TleEphemeris
from typing import Optional, Set
from typing_extensions import Self

class EphemerisWithAttitude(BaseModel):
    """
    EphemerisWithAttitude
    """ # noqa: E501
    cartesian_ephemeris: Optional[CartesianEphemeris] = Field(default=None, alias="cartesianEphemeris")
    geodetic_ephemeris: Optional[GeodeticEphemeris] = Field(default=None, alias="geodeticEphemeris")
    mean_orbit_ephemeris: Optional[MeanOrbitEphemeris] = Field(default=None, alias="meanOrbitEphemeris")
    osculating_orbit_ephemeris: Optional[OsculatingOrbitEphemeris] = Field(default=None, alias="osculatingOrbitEphemeris")
    tle_ephemeris: Optional[TleEphemeris] = Field(default=None, alias="tleEphemeris")
    celestial_relative_ephemeris: Optional[CelestialRelativePositionEphemeris] = Field(default=None, alias="celestialRelativeEphemeris")
    secondary_relative_ephemeris: Optional[SecondaryRelativeCartesianEphemeris] = Field(default=None, alias="secondaryRelativeEphemeris")
    terrestrial_relative_ephemeris: Optional[TerrestrialRelativePositionEphemeris] = Field(default=None, alias="terrestrialRelativeEphemeris")
    cartesian_covariance_ephemeris: Optional[CartesianCovarianceEphemeris] = Field(default=None, alias="cartesianCovarianceEphemeris")
    mass_ephemeris: Optional[MassEphemeris] = Field(default=None, alias="massEphemeris")
    orbital_covariance_ephemeris: Optional[OrbitalCovarianceEphemeris] = Field(default=None, alias="orbitalCovarianceEphemeris")
    thrust_vector_ephemeris: Optional[ThrustVectorEphemeris] = Field(default=None, alias="thrustVectorEphemeris")
    battery_power_ephemeris: Optional[BatteryPowerEphemeris] = Field(default=None, alias="batteryPowerEphemeris")
    attitude_ephemeris: Optional[AttitudeEphemeris] = Field(default=None, alias="attitudeEphemeris")
    __properties: ClassVar[List[str]] = ["cartesianEphemeris", "geodeticEphemeris", "meanOrbitEphemeris", "osculatingOrbitEphemeris", "tleEphemeris", "celestialRelativeEphemeris", "secondaryRelativeEphemeris", "terrestrialRelativeEphemeris", "cartesianCovarianceEphemeris", "massEphemeris", "orbitalCovarianceEphemeris", "thrustVectorEphemeris", "batteryPowerEphemeris", "attitudeEphemeris"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EphemerisWithAttitude from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cartesian_ephemeris
        if self.cartesian_ephemeris:
            _dict['cartesianEphemeris'] = self.cartesian_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of geodetic_ephemeris
        if self.geodetic_ephemeris:
            _dict['geodeticEphemeris'] = self.geodetic_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mean_orbit_ephemeris
        if self.mean_orbit_ephemeris:
            _dict['meanOrbitEphemeris'] = self.mean_orbit_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of osculating_orbit_ephemeris
        if self.osculating_orbit_ephemeris:
            _dict['osculatingOrbitEphemeris'] = self.osculating_orbit_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tle_ephemeris
        if self.tle_ephemeris:
            _dict['tleEphemeris'] = self.tle_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of celestial_relative_ephemeris
        if self.celestial_relative_ephemeris:
            _dict['celestialRelativeEphemeris'] = self.celestial_relative_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secondary_relative_ephemeris
        if self.secondary_relative_ephemeris:
            _dict['secondaryRelativeEphemeris'] = self.secondary_relative_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of terrestrial_relative_ephemeris
        if self.terrestrial_relative_ephemeris:
            _dict['terrestrialRelativeEphemeris'] = self.terrestrial_relative_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cartesian_covariance_ephemeris
        if self.cartesian_covariance_ephemeris:
            _dict['cartesianCovarianceEphemeris'] = self.cartesian_covariance_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mass_ephemeris
        if self.mass_ephemeris:
            _dict['massEphemeris'] = self.mass_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orbital_covariance_ephemeris
        if self.orbital_covariance_ephemeris:
            _dict['orbitalCovarianceEphemeris'] = self.orbital_covariance_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of thrust_vector_ephemeris
        if self.thrust_vector_ephemeris:
            _dict['thrustVectorEphemeris'] = self.thrust_vector_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of battery_power_ephemeris
        if self.battery_power_ephemeris:
            _dict['batteryPowerEphemeris'] = self.battery_power_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attitude_ephemeris
        if self.attitude_ephemeris:
            _dict['attitudeEphemeris'] = self.attitude_ephemeris.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EphemerisWithAttitude from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cartesianEphemeris": CartesianEphemeris.from_dict(obj["cartesianEphemeris"]) if obj.get("cartesianEphemeris") is not None else None,
            "geodeticEphemeris": GeodeticEphemeris.from_dict(obj["geodeticEphemeris"]) if obj.get("geodeticEphemeris") is not None else None,
            "meanOrbitEphemeris": MeanOrbitEphemeris.from_dict(obj["meanOrbitEphemeris"]) if obj.get("meanOrbitEphemeris") is not None else None,
            "osculatingOrbitEphemeris": OsculatingOrbitEphemeris.from_dict(obj["osculatingOrbitEphemeris"]) if obj.get("osculatingOrbitEphemeris") is not None else None,
            "tleEphemeris": TleEphemeris.from_dict(obj["tleEphemeris"]) if obj.get("tleEphemeris") is not None else None,
            "celestialRelativeEphemeris": CelestialRelativePositionEphemeris.from_dict(obj["celestialRelativeEphemeris"]) if obj.get("celestialRelativeEphemeris") is not None else None,
            "secondaryRelativeEphemeris": SecondaryRelativeCartesianEphemeris.from_dict(obj["secondaryRelativeEphemeris"]) if obj.get("secondaryRelativeEphemeris") is not None else None,
            "terrestrialRelativeEphemeris": TerrestrialRelativePositionEphemeris.from_dict(obj["terrestrialRelativeEphemeris"]) if obj.get("terrestrialRelativeEphemeris") is not None else None,
            "cartesianCovarianceEphemeris": CartesianCovarianceEphemeris.from_dict(obj["cartesianCovarianceEphemeris"]) if obj.get("cartesianCovarianceEphemeris") is not None else None,
            "massEphemeris": MassEphemeris.from_dict(obj["massEphemeris"]) if obj.get("massEphemeris") is not None else None,
            "orbitalCovarianceEphemeris": OrbitalCovarianceEphemeris.from_dict(obj["orbitalCovarianceEphemeris"]) if obj.get("orbitalCovarianceEphemeris") is not None else None,
            "thrustVectorEphemeris": ThrustVectorEphemeris.from_dict(obj["thrustVectorEphemeris"]) if obj.get("thrustVectorEphemeris") is not None else None,
            "batteryPowerEphemeris": BatteryPowerEphemeris.from_dict(obj["batteryPowerEphemeris"]) if obj.get("batteryPowerEphemeris") is not None else None,
            "attitudeEphemeris": AttitudeEphemeris.from_dict(obj["attitudeEphemeris"]) if obj.get("attitudeEphemeris") is not None else None
        })
        return _obj


