# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from spacetower_orbit_extrapolation_python_client.models.ephemeris_time_grid_configuration import EphemerisTimeGridConfiguration
from spacetower_orbit_extrapolation_python_client.models.secondary_object_definition import SecondaryObjectDefinition
from spacetower_orbit_extrapolation_python_client.models.secondary_propagation_type import SecondaryPropagationType
from spacetower_orbit_extrapolation_python_client.models.secondary_relative_frame_type import SecondaryRelativeFrameType
from typing import Optional, Set
from typing_extensions import Self

class SecondaryRelativeCartesianEphemerisRequest(BaseModel):
    """
    Options for exporting relative position and velocity vectors of secondaries w.r.t. space object
    """ # noqa: E501
    time_grid_configuration: Optional[EphemerisTimeGridConfiguration] = Field(default=None, alias="timeGridConfiguration")
    start_date: Optional[str] = Field(default=None, description="The start date (UTC) of the ephemeris generation interval. If not provided, the initial date of the simulation is used", alias="startDate")
    end_date: Optional[str] = Field(default=None, description="The end date (UTC) of the ephemeris generation interval. If not provided, the final date of the simulation is used", alias="endDate")
    secondary_frame_type: SecondaryRelativeFrameType = Field(alias="secondaryFrameType")
    propagation_type: Optional[SecondaryPropagationType] = Field(default=None, alias="propagationType")
    secondary_objects: Optional[Annotated[List[SecondaryObjectDefinition], Field(min_length=1)]] = Field(default=None, alias="secondaryObjects")
    __properties: ClassVar[List[str]] = ["timeGridConfiguration", "startDate", "endDate", "secondaryFrameType", "propagationType", "secondaryObjects"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecondaryRelativeCartesianEphemerisRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_grid_configuration
        if self.time_grid_configuration:
            _dict['timeGridConfiguration'] = self.time_grid_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in secondary_objects (list)
        _items = []
        if self.secondary_objects:
            for _item in self.secondary_objects:
                if _item:
                    _items.append(_item.to_dict())
            _dict['secondaryObjects'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecondaryRelativeCartesianEphemerisRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timeGridConfiguration": EphemerisTimeGridConfiguration.from_dict(obj["timeGridConfiguration"]) if obj.get("timeGridConfiguration") is not None else None,
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "secondaryFrameType": obj.get("secondaryFrameType"),
            "propagationType": obj.get("propagationType"),
            "secondaryObjects": [SecondaryObjectDefinition.from_dict(_item) for _item in obj["secondaryObjects"]] if obj.get("secondaryObjects") is not None else None
        })
        return _obj


