# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.ephemeris_generation_requests import EphemerisGenerationRequests
from spacetower_orbit_extrapolation_python_client.models.event_generation_requests import EventGenerationRequests
from spacetower_orbit_extrapolation_python_client.models.output_configuration import OutputConfiguration
from spacetower_orbit_extrapolation_python_client.models.tle import TLE
from typing import Optional, Set
from typing_extensions import Self

class TleExtrapolationRequest(BaseModel):
    """
    Configuration for TLE extrapolation using simplified perturbations models
    """ # noqa: E501
    target_date: str = Field(description="timescale UTC", alias="targetDate")
    output_configuration: Optional[OutputConfiguration] = Field(default=None, alias="outputConfiguration")
    tle: TLE
    event_generation_requests: Optional[EventGenerationRequests] = Field(default=None, alias="eventGenerationRequests")
    ephemeris_generation_requests: Optional[EphemerisGenerationRequests] = Field(default=None, alias="ephemerisGenerationRequests")
    __properties: ClassVar[List[str]] = ["targetDate", "outputConfiguration", "tle", "eventGenerationRequests", "ephemerisGenerationRequests"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TleExtrapolationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of output_configuration
        if self.output_configuration:
            _dict['outputConfiguration'] = self.output_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tle
        if self.tle:
            _dict['tle'] = self.tle.to_dict()
        # override the default output from pydantic by calling `to_dict()` of event_generation_requests
        if self.event_generation_requests:
            _dict['eventGenerationRequests'] = self.event_generation_requests.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ephemeris_generation_requests
        if self.ephemeris_generation_requests:
            _dict['ephemerisGenerationRequests'] = self.ephemeris_generation_requests.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TleExtrapolationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "targetDate": obj.get("targetDate"),
            "outputConfiguration": OutputConfiguration.from_dict(obj["outputConfiguration"]) if obj.get("outputConfiguration") is not None else None,
            "tle": TLE.from_dict(obj["tle"]) if obj.get("tle") is not None else None,
            "eventGenerationRequests": EventGenerationRequests.from_dict(obj["eventGenerationRequests"]) if obj.get("eventGenerationRequests") is not None else None,
            "ephemerisGenerationRequests": EphemerisGenerationRequests.from_dict(obj["ephemerisGenerationRequests"]) if obj.get("ephemerisGenerationRequests") is not None else None
        })
        return _obj


