# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.3.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class DatedLocalFrameFiniteThrustDirection(BaseModel):
    """
    Thrust direction in a local frame defined by the starting date and firing duration
    """ # noqa: E501
    start_date: str = Field(description="timescale UTC", alias="startDate")
    duration: Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]] = Field(description="Units [s]")
    thrust_direction_right_ascension: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Angle between the projection of the thrust vector on the xy-plane and the x-axis of the local frame. Units [rad]", alias="thrustDirectionRightAscension")
    thrust_direction_declination: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Angle between the xy-plane of the local frame and the thrust vector. Units [rad]", alias="thrustDirectionDeclination")
    __properties: ClassVar[List[str]] = ["startDate", "duration", "thrustDirectionRightAscension", "thrustDirectionDeclination"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatedLocalFrameFiniteThrustDirection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatedLocalFrameFiniteThrustDirection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "startDate": obj.get("startDate"),
            "duration": obj.get("duration"),
            "thrustDirectionRightAscension": obj.get("thrustDirectionRightAscension"),
            "thrustDirectionDeclination": obj.get("thrustDirectionDeclination")
        })
        return _obj


