# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.earth_occultation_type import EarthOccultationType
from spacetower_orbit_extrapolation_python_client.models.field_of_view_event_types import FieldOfViewEventTypes
from typing import Optional, Set
from typing_extensions import Self

class FieldOfViewEventLog(BaseModel):
    """
    Information on target (celestial body) acquisitions
    """ # noqa: E501
    utc_date: str = Field(description="The date at which the target celestial body starts entering the Field of View", alias="utcDate")
    event_type: FieldOfViewEventTypes = Field(alias="eventType")
    body_name: Optional[StrictStr] = Field(default=None, description="Name of target celestial body", alias="bodyName")
    earth_occultation_type: Optional[EarthOccultationType] = Field(default=None, alias="earthOccultationType")
    __properties: ClassVar[List[str]] = ["utcDate", "eventType", "bodyName", "earthOccultationType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldOfViewEventLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldOfViewEventLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "utcDate": obj.get("utcDate"),
            "eventType": obj.get("eventType"),
            "bodyName": obj.get("bodyName"),
            "earthOccultationType": obj.get("earthOccultationType")
        })
        return _obj


