# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.orbit import Orbit
from spacetower_orbit_extrapolation_python_client.models.orbital_covariance_matrix import OrbitalCovarianceMatrix
from spacetower_orbit_extrapolation_python_client.models.output_configuration import OutputConfiguration
from spacetower_orbit_extrapolation_python_client.models.simulation_configuration import SimulationConfiguration
from typing import Optional, Set
from typing_extensions import Self

class NumericalExtrapolationRequestCommonFields(BaseModel):
    """
    Common fields for all numerical extrapolation requests
    """ # noqa: E501
    target_date: str = Field(description="timescale UTC", alias="targetDate")
    output_configuration: Optional[OutputConfiguration] = Field(default=None, alias="outputConfiguration")
    data: Optional[Dict[str, StrictStr]] = Field(default=None, description="References to the data to be used during the computation")
    initial_covariance_matrix: Optional[OrbitalCovarianceMatrix] = Field(default=None, alias="initialCovarianceMatrix")
    initial_orbit: Orbit = Field(alias="initialOrbit")
    simulation_configuration: SimulationConfiguration = Field(alias="simulationConfiguration")
    __properties: ClassVar[List[str]] = ["targetDate", "outputConfiguration", "data", "initialCovarianceMatrix", "initialOrbit", "simulationConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalExtrapolationRequestCommonFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of output_configuration
        if self.output_configuration:
            _dict['outputConfiguration'] = self.output_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_covariance_matrix
        if self.initial_covariance_matrix:
            _dict['initialCovarianceMatrix'] = self.initial_covariance_matrix.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_orbit
        if self.initial_orbit:
            _dict['initialOrbit'] = self.initial_orbit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of simulation_configuration
        if self.simulation_configuration:
            _dict['simulationConfiguration'] = self.simulation_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalExtrapolationRequestCommonFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "targetDate": obj.get("targetDate"),
            "outputConfiguration": OutputConfiguration.from_dict(obj["outputConfiguration"]) if obj.get("outputConfiguration") is not None else None,
            "data": obj.get("data"),
            "initialCovarianceMatrix": OrbitalCovarianceMatrix.from_dict(obj["initialCovarianceMatrix"]) if obj.get("initialCovarianceMatrix") is not None else None,
            "initialOrbit": Orbit.from_dict(obj["initialOrbit"]) if obj.get("initialOrbit") is not None else None,
            "simulationConfiguration": SimulationConfiguration.from_dict(obj["simulationConfiguration"]) if obj.get("simulationConfiguration") is not None else None
        })
        return _obj


