# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from spacetower_orbit_extrapolation_python_client.models.battery_model import BatteryModel
from spacetower_orbit_extrapolation_python_client.models.propulsion_system import PropulsionSystem
from spacetower_orbit_extrapolation_python_client.models.solar_array_system import SolarArraySystem
from spacetower_orbit_extrapolation_python_client.models.space_object_type import SpaceObjectType
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_extrapolation_python_client.models.box_object import BoxObject
    from spacetower_orbit_extrapolation_python_client.models.isotropic_object import IsotropicObject

class SpaceObject(BaseModel):
    """
    An orbiting body
    """ # noqa: E501
    mass: Optional[Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]]] = Field(default=1000, description="Units [kg]")
    drag_coefficient: Optional[Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]]] = Field(default=2.2, description="Dimensionless drag coefficient. Units [-]", alias="dragCoefficient")
    propulsion_system: Optional[PropulsionSystem] = Field(default=None, alias="propulsionSystem")
    solar_array_system: Optional[SolarArraySystem] = Field(default=None, alias="solarArraySystem")
    battery_model: Optional[BatteryModel] = Field(default=None, alias="batteryModel")
    space_object_type: SpaceObjectType = Field(alias="spaceObjectType")
    __properties: ClassVar[List[str]] = ["mass", "dragCoefficient", "propulsionSystem", "solarArraySystem", "batteryModel", "spaceObjectType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'spaceObjectType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'BOX': 'BoxObject','ISOTROPIC': 'IsotropicObject'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[BoxObject, IsotropicObject]]:
        """Create an instance of SpaceObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of propulsion_system
        if self.propulsion_system:
            _dict['propulsionSystem'] = self.propulsion_system.to_dict()
        # override the default output from pydantic by calling `to_dict()` of solar_array_system
        if self.solar_array_system:
            _dict['solarArraySystem'] = self.solar_array_system.to_dict()
        # override the default output from pydantic by calling `to_dict()` of battery_model
        if self.battery_model:
            _dict['batteryModel'] = self.battery_model.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[BoxObject, IsotropicObject]]:
        """Create an instance of SpaceObject from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'BoxObject':
            return import_module("spacetower_orbit_extrapolation_python_client.models.box_object").BoxObject.from_dict(obj)
        if object_type ==  'IsotropicObject':
            return import_module("spacetower_orbit_extrapolation_python_client.models.isotropic_object").IsotropicObject.from_dict(obj)

        raise ValueError("SpaceObject failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


