# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from spacetower_orbit_extrapolation_python_client.models.event_detection_type import EventDetectionType
from spacetower_orbit_extrapolation_python_client.models.ground_station import GroundStation
from spacetower_orbit_extrapolation_python_client.models.time_span import TimeSpan
from typing import Optional, Set
from typing_extensions import Self

class StationEventRequest(BaseModel):
    """
    Log passes over a set of ground stations
    """ # noqa: E501
    event_detection_type: Optional[EventDetectionType] = Field(default=None, alias="eventDetectionType")
    time_span: Optional[TimeSpan] = Field(default=None, alias="timeSpan")
    minimum_duration: Optional[Union[Annotated[float, Field(strict=True, ge=10.0)], Annotated[int, Field(strict=True, ge=10)]]] = Field(default=60.0, description="Minimum duration of passes to consider (a value unrealistically small would lower computational performance). Units [s]", alias="minimumDuration")
    ground_stations: Annotated[List[GroundStation], Field(min_length=1)] = Field(description="The list of ground stations for which passes are to be logged", alias="groundStations")
    __properties: ClassVar[List[str]] = ["eventDetectionType", "timeSpan", "minimumDuration", "groundStations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StationEventRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_span
        if self.time_span:
            _dict['timeSpan'] = self.time_span.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ground_stations (list)
        _items = []
        if self.ground_stations:
            for _item in self.ground_stations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['groundStations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StationEventRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventDetectionType": obj.get("eventDetectionType"),
            "timeSpan": TimeSpan.from_dict(obj["timeSpan"]) if obj.get("timeSpan") is not None else None,
            "minimumDuration": obj.get("minimumDuration") if obj.get("minimumDuration") is not None else 60.0,
            "groundStations": [GroundStation.from_dict(_item) for _item in obj["groundStations"]] if obj.get("groundStations") is not None else None
        })
        return _obj


