# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict
from typing import Any, ClassVar, Dict, List
from spacetower_orbit_extrapolation_python_client.models.secondary_object_definition import SecondaryObjectDefinition
from spacetower_orbit_extrapolation_python_client.models.secondary_object_event_definition import SecondaryObjectEventDefinition
from spacetower_orbit_extrapolation_python_client.models.secondary_object_event_definition_type import SecondaryObjectEventDefinitionType
from spacetower_orbit_extrapolation_python_client.models.secondary_propagation_type import SecondaryPropagationType
from typing import Optional, Set
from typing_extensions import Self

class ClosestApproachDefinition(SecondaryObjectEventDefinition):
    """
    Computes Time of Closest Approach (TCA) with secondary object assuming analytical propagation i.e. Keplerian or SGP4 (need a TleOrbit for the latter). This assumes that the state is given relatively close to the actual TCA (or event very close for Keplerian, as in the case of a Conjunction Data Message for instance)
    """ # noqa: E501
    __properties: ClassVar[List[str]] = ["eventDefinitionType", "propagationType", "secondaryObject"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClosestApproachDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of secondary_object
        if self.secondary_object:
            _dict['secondaryObject'] = self.secondary_object.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClosestApproachDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventDefinitionType": obj.get("eventDefinitionType"),
            "propagationType": obj.get("propagationType"),
            "secondaryObject": SecondaryObjectDefinition.from_dict(obj["secondaryObject"]) if obj.get("secondaryObject") is not None else None
        })
        return _obj


