# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.event_detection_type import EventDetectionType
from spacetower_orbit_extrapolation_python_client.models.orbit import Orbit
from spacetower_orbit_extrapolation_python_client.models.secondary_propagation_type import SecondaryPropagationType
from spacetower_orbit_extrapolation_python_client.models.time_span import TimeSpan
from typing import Optional, Set
from typing_extensions import Self

class ConjunctionEventRequest(BaseModel):
    """
    Computes Time of Closest Approach (TCA) with secondary object assuming analytical propagation: Keplerian or SGP4 (need a TleOrbit for the latter). This assumes that the state is given relatively close to the actual TCA (or event very close for Keplerian, as in the case of a Conjunction Data Message for instance) 
    """ # noqa: E501
    event_detection_type: Optional[EventDetectionType] = Field(default=None, alias="eventDetectionType")
    time_span: Optional[TimeSpan] = Field(default=None, alias="timeSpan")
    secondary_name: Optional[StrictStr] = Field(default=None, description="Name of the secondary object", alias="secondaryName")
    secondary_orbit: Optional[Orbit] = Field(default=None, alias="secondaryOrbit")
    secondary_propagation_type: Optional[SecondaryPropagationType] = Field(default=None, alias="secondaryPropagationType")
    __properties: ClassVar[List[str]] = ["eventDetectionType", "timeSpan", "secondaryName", "secondaryOrbit", "secondaryPropagationType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConjunctionEventRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_span
        if self.time_span:
            _dict['timeSpan'] = self.time_span.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secondary_orbit
        if self.secondary_orbit:
            _dict['secondaryOrbit'] = self.secondary_orbit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConjunctionEventRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventDetectionType": obj.get("eventDetectionType"),
            "timeSpan": TimeSpan.from_dict(obj["timeSpan"]) if obj.get("timeSpan") is not None else None,
            "secondaryName": obj.get("secondaryName"),
            "secondaryOrbit": Orbit.from_dict(obj["secondaryOrbit"]) if obj.get("secondaryOrbit") is not None else None,
            "secondaryPropagationType": obj.get("secondaryPropagationType")
        })
        return _obj


