# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.battery_power_ephemeris_request import BatteryPowerEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.cartesian_covariance_ephemeris_request import CartesianCovarianceEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.cartesian_ephemeris_request import CartesianEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.celestial_relative_position_ephemeris_request import CelestialRelativePositionEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.geodetic_ephemeris_request import GeodeticEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.mass_ephemeris_request import MassEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.mean_orbit_ephemeris_request import MeanOrbitEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.orbital_covariance_ephemeris_request import OrbitalCovarianceEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.osculating_orbit_ephemeris_request import OsculatingOrbitEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.secondary_relative_cartesian_ephemeris_request import SecondaryRelativeCartesianEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.terrestrial_relative_position_ephemeris_request import TerrestrialRelativePositionEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.thrust_vector_ephemeris_request import ThrustVectorEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.tle_ephemeris_request import TleEphemerisRequest
from typing import Optional, Set
from typing_extensions import Self

class EphemerisGenerationRequestsWithoutAttitude(BaseModel):
    """
    Options of ephemeris to be generated. If a ephemeris request is not provided, it will not be computed 
    """ # noqa: E501
    osculating_orbit_ephemeris_request: Optional[OsculatingOrbitEphemerisRequest] = Field(default=None, alias="osculatingOrbitEphemerisRequest")
    mean_orbit_ephemeris_request: Optional[MeanOrbitEphemerisRequest] = Field(default=None, alias="meanOrbitEphemerisRequest")
    cartesian_ephemeris_request: Optional[CartesianEphemerisRequest] = Field(default=None, alias="cartesianEphemerisRequest")
    geodetic_ephemeris_request: Optional[GeodeticEphemerisRequest] = Field(default=None, alias="geodeticEphemerisRequest")
    tle_ephemeris_request: Optional[TleEphemerisRequest] = Field(default=None, alias="tleEphemerisRequest")
    celestial_relative_ephemeris_request: Optional[CelestialRelativePositionEphemerisRequest] = Field(default=None, alias="celestialRelativeEphemerisRequest")
    secondary_relative_ephemeris_request: Optional[SecondaryRelativeCartesianEphemerisRequest] = Field(default=None, alias="secondaryRelativeEphemerisRequest")
    terrestrial_relative_ephemeris_request: Optional[TerrestrialRelativePositionEphemerisRequest] = Field(default=None, alias="terrestrialRelativeEphemerisRequest")
    mass_ephemeris_request: Optional[MassEphemerisRequest] = Field(default=None, alias="massEphemerisRequest")
    cartesian_covariance_ephemeris_request: Optional[CartesianCovarianceEphemerisRequest] = Field(default=None, alias="cartesianCovarianceEphemerisRequest")
    orbital_covariance_ephemeris_request: Optional[OrbitalCovarianceEphemerisRequest] = Field(default=None, alias="orbitalCovarianceEphemerisRequest")
    battery_power_ephemeris_request: Optional[BatteryPowerEphemerisRequest] = Field(default=None, alias="batteryPowerEphemerisRequest")
    thrust_vector_ephemeris_request: Optional[ThrustVectorEphemerisRequest] = Field(default=None, alias="thrustVectorEphemerisRequest")
    __properties: ClassVar[List[str]] = ["osculatingOrbitEphemerisRequest", "meanOrbitEphemerisRequest", "cartesianEphemerisRequest", "geodeticEphemerisRequest", "tleEphemerisRequest", "celestialRelativeEphemerisRequest", "secondaryRelativeEphemerisRequest", "terrestrialRelativeEphemerisRequest", "massEphemerisRequest", "cartesianCovarianceEphemerisRequest", "orbitalCovarianceEphemerisRequest", "batteryPowerEphemerisRequest", "thrustVectorEphemerisRequest"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EphemerisGenerationRequestsWithoutAttitude from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of osculating_orbit_ephemeris_request
        if self.osculating_orbit_ephemeris_request:
            _dict['osculatingOrbitEphemerisRequest'] = self.osculating_orbit_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mean_orbit_ephemeris_request
        if self.mean_orbit_ephemeris_request:
            _dict['meanOrbitEphemerisRequest'] = self.mean_orbit_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cartesian_ephemeris_request
        if self.cartesian_ephemeris_request:
            _dict['cartesianEphemerisRequest'] = self.cartesian_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of geodetic_ephemeris_request
        if self.geodetic_ephemeris_request:
            _dict['geodeticEphemerisRequest'] = self.geodetic_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tle_ephemeris_request
        if self.tle_ephemeris_request:
            _dict['tleEphemerisRequest'] = self.tle_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of celestial_relative_ephemeris_request
        if self.celestial_relative_ephemeris_request:
            _dict['celestialRelativeEphemerisRequest'] = self.celestial_relative_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secondary_relative_ephemeris_request
        if self.secondary_relative_ephemeris_request:
            _dict['secondaryRelativeEphemerisRequest'] = self.secondary_relative_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of terrestrial_relative_ephemeris_request
        if self.terrestrial_relative_ephemeris_request:
            _dict['terrestrialRelativeEphemerisRequest'] = self.terrestrial_relative_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mass_ephemeris_request
        if self.mass_ephemeris_request:
            _dict['massEphemerisRequest'] = self.mass_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cartesian_covariance_ephemeris_request
        if self.cartesian_covariance_ephemeris_request:
            _dict['cartesianCovarianceEphemerisRequest'] = self.cartesian_covariance_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orbital_covariance_ephemeris_request
        if self.orbital_covariance_ephemeris_request:
            _dict['orbitalCovarianceEphemerisRequest'] = self.orbital_covariance_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of battery_power_ephemeris_request
        if self.battery_power_ephemeris_request:
            _dict['batteryPowerEphemerisRequest'] = self.battery_power_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of thrust_vector_ephemeris_request
        if self.thrust_vector_ephemeris_request:
            _dict['thrustVectorEphemerisRequest'] = self.thrust_vector_ephemeris_request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EphemerisGenerationRequestsWithoutAttitude from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "osculatingOrbitEphemerisRequest": OsculatingOrbitEphemerisRequest.from_dict(obj["osculatingOrbitEphemerisRequest"]) if obj.get("osculatingOrbitEphemerisRequest") is not None else None,
            "meanOrbitEphemerisRequest": MeanOrbitEphemerisRequest.from_dict(obj["meanOrbitEphemerisRequest"]) if obj.get("meanOrbitEphemerisRequest") is not None else None,
            "cartesianEphemerisRequest": CartesianEphemerisRequest.from_dict(obj["cartesianEphemerisRequest"]) if obj.get("cartesianEphemerisRequest") is not None else None,
            "geodeticEphemerisRequest": GeodeticEphemerisRequest.from_dict(obj["geodeticEphemerisRequest"]) if obj.get("geodeticEphemerisRequest") is not None else None,
            "tleEphemerisRequest": TleEphemerisRequest.from_dict(obj["tleEphemerisRequest"]) if obj.get("tleEphemerisRequest") is not None else None,
            "celestialRelativeEphemerisRequest": CelestialRelativePositionEphemerisRequest.from_dict(obj["celestialRelativeEphemerisRequest"]) if obj.get("celestialRelativeEphemerisRequest") is not None else None,
            "secondaryRelativeEphemerisRequest": SecondaryRelativeCartesianEphemerisRequest.from_dict(obj["secondaryRelativeEphemerisRequest"]) if obj.get("secondaryRelativeEphemerisRequest") is not None else None,
            "terrestrialRelativeEphemerisRequest": TerrestrialRelativePositionEphemerisRequest.from_dict(obj["terrestrialRelativeEphemerisRequest"]) if obj.get("terrestrialRelativeEphemerisRequest") is not None else None,
            "massEphemerisRequest": MassEphemerisRequest.from_dict(obj["massEphemerisRequest"]) if obj.get("massEphemerisRequest") is not None else None,
            "cartesianCovarianceEphemerisRequest": CartesianCovarianceEphemerisRequest.from_dict(obj["cartesianCovarianceEphemerisRequest"]) if obj.get("cartesianCovarianceEphemerisRequest") is not None else None,
            "orbitalCovarianceEphemerisRequest": OrbitalCovarianceEphemerisRequest.from_dict(obj["orbitalCovarianceEphemerisRequest"]) if obj.get("orbitalCovarianceEphemerisRequest") is not None else None,
            "batteryPowerEphemerisRequest": BatteryPowerEphemerisRequest.from_dict(obj["batteryPowerEphemerisRequest"]) if obj.get("batteryPowerEphemerisRequest") is not None else None,
            "thrustVectorEphemerisRequest": ThrustVectorEphemerisRequest.from_dict(obj["thrustVectorEphemerisRequest"]) if obj.get("thrustVectorEphemerisRequest") is not None else None
        })
        return _obj


