# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from spacetower_orbit_extrapolation_python_client.models.anomaly_type import AnomalyType
from spacetower_orbit_extrapolation_python_client.models.inertial_frame_id import InertialFrameId
from spacetower_orbit_extrapolation_python_client.models.mean_osculating_orbit_type import MeanOsculatingOrbitType
from spacetower_orbit_extrapolation_python_client.models.orbit import Orbit
from spacetower_orbit_extrapolation_python_client.models.orbit_type import OrbitType
from typing import Optional, Set
from typing_extensions import Self

class EquinoctialOrbit(Orbit):
    """
    An orbit described by equinoctial parameters. The Earth's gravitational parameter is the EGM96 one
    """ # noqa: E501
    var_date: str = Field(description="The orbit epoch (UTC)", alias="date")
    semi_major_axis: Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]] = Field(description="The orbit semi-major axis. Units [m]", alias="semiMajorAxis")
    eccentricity_vector_x: Union[Annotated[float, Field(le=1, strict=True, ge=-1)], Annotated[int, Field(le=1, strict=True, ge=-1)]] = Field(description="Component x of the eccentricity vector. Units [-]", alias="eccentricityVectorX")
    eccentricity_vector_y: Union[Annotated[float, Field(le=1, strict=True, ge=-1)], Annotated[int, Field(le=1, strict=True, ge=-1)]] = Field(description="Component y of the eccentricity vector. Units [-]", alias="eccentricityVectorY")
    inclination_vector_x: Union[StrictFloat, StrictInt] = Field(description="The x component of the inclination vector. Units [-]", alias="inclinationVectorX")
    inclination_vector_y: Union[StrictFloat, StrictInt] = Field(description="The y component of the inclination vector. Units [-]", alias="inclinationVectorY")
    equinoctial_longitude: Union[StrictFloat, StrictInt] = Field(description="The equinoctial longitude. Units [rad]", alias="equinoctialLongitude")
    anomaly_type: Optional[AnomalyType] = Field(default=None, alias="anomalyType")
    mean_osc_type: MeanOsculatingOrbitType = Field(alias="meanOscType")
    inertial_frame_id: Optional[InertialFrameId] = Field(default=None, alias="inertialFrameId")
    __properties: ClassVar[List[str]] = ["orbitType", "date", "semiMajorAxis", "eccentricityVectorX", "eccentricityVectorY", "inclinationVectorX", "inclinationVectorY", "equinoctialLongitude", "anomalyType", "meanOscType", "inertialFrameId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EquinoctialOrbit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EquinoctialOrbit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orbitType": obj.get("orbitType"),
            "date": obj.get("date"),
            "semiMajorAxis": obj.get("semiMajorAxis"),
            "eccentricityVectorX": obj.get("eccentricityVectorX"),
            "eccentricityVectorY": obj.get("eccentricityVectorY"),
            "inclinationVectorX": obj.get("inclinationVectorX"),
            "inclinationVectorY": obj.get("inclinationVectorY"),
            "equinoctialLongitude": obj.get("equinoctialLongitude"),
            "anomalyType": obj.get("anomalyType"),
            "meanOscType": obj.get("meanOscType"),
            "inertialFrameId": obj.get("inertialFrameId")
        })
        return _obj


