# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Union
from spacetower_orbit_extrapolation_python_client.models.orbit_type import OrbitType
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_extrapolation_python_client.models.cartesian_orbit import CartesianOrbit
    from spacetower_orbit_extrapolation_python_client.models.circular_orbit import CircularOrbit
    from spacetower_orbit_extrapolation_python_client.models.equinoctial_orbit import EquinoctialOrbit
    from spacetower_orbit_extrapolation_python_client.models.keplerian_orbit import KeplerianOrbit
    from spacetower_orbit_extrapolation_python_client.models.two_line_element_orbit import TwoLineElementOrbit

class Orbit(BaseModel):
    """
    Orbit representation by either parameters (Cartesian parameters or orbital elements) or a Two Line Elements (TLE)
    """ # noqa: E501
    orbit_type: OrbitType = Field(alias="orbitType")
    __properties: ClassVar[List[str]] = ["orbitType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'orbitType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'CARTESIAN': 'CartesianOrbit','CIRCULAR': 'CircularOrbit','EQUINOCTIAL': 'EquinoctialOrbit','KEPLERIAN': 'KeplerianOrbit','TLE_ORBIT': 'TwoLineElementOrbit'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[CartesianOrbit, CircularOrbit, EquinoctialOrbit, KeplerianOrbit, TwoLineElementOrbit]]:
        """Create an instance of Orbit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[CartesianOrbit, CircularOrbit, EquinoctialOrbit, KeplerianOrbit, TwoLineElementOrbit]]:
        """Create an instance of Orbit from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'CartesianOrbit':
            return import_module("spacetower_orbit_extrapolation_python_client.models.cartesian_orbit").CartesianOrbit.from_dict(obj)
        if object_type ==  'CircularOrbit':
            return import_module("spacetower_orbit_extrapolation_python_client.models.circular_orbit").CircularOrbit.from_dict(obj)
        if object_type ==  'EquinoctialOrbit':
            return import_module("spacetower_orbit_extrapolation_python_client.models.equinoctial_orbit").EquinoctialOrbit.from_dict(obj)
        if object_type ==  'KeplerianOrbit':
            return import_module("spacetower_orbit_extrapolation_python_client.models.keplerian_orbit").KeplerianOrbit.from_dict(obj)
        if object_type ==  'TwoLineElementOrbit':
            return import_module("spacetower_orbit_extrapolation_python_client.models.two_line_element_orbit").TwoLineElementOrbit.from_dict(obj)

        raise ValueError("Orbit failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


