# spacetower_orbit_extrapolation_python_client
Orbit Extrapolation API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.4.4
- Package version: 2.4.4
- Generator version: 7.6.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import spacetower_orbit_extrapolation_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import spacetower_orbit_extrapolation_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import spacetower_orbit_extrapolation_python_client
from spacetower_orbit_extrapolation_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://orbit-extrapolation.exoops.57.128.40.142.sslip.io
# See configuration.py for a list of all supported configuration parameters.
configuration = spacetower_orbit_extrapolation_python_client.Configuration(
    host = "http://orbit-extrapolation.exoops.57.128.40.142.sslip.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = spacetower_orbit_extrapolation_python_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with spacetower_orbit_extrapolation_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = spacetower_orbit_extrapolation_python_client.DefaultApi(api_client)
    numerical_extrapolation_with_attitude_simulation_request = spacetower_orbit_extrapolation_python_client.NumericalExtrapolationWithAttitudeSimulationRequest() # NumericalExtrapolationWithAttitudeSimulationRequest |  (optional)

    try:
        # Numerical extrapolation with attitude simulation
        api_response = api_instance.compute_numerical_extrapolation_with_attitude(numerical_extrapolation_with_attitude_simulation_request=numerical_extrapolation_with_attitude_simulation_request)
        print("The response of DefaultApi->compute_numerical_extrapolation_with_attitude:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->compute_numerical_extrapolation_with_attitude: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://orbit-extrapolation.exoops.57.128.40.142.sslip.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**compute_numerical_extrapolation_with_attitude**](docs/DefaultApi.md#compute_numerical_extrapolation_with_attitude) | **POST** /extrapolation/numerical-with-attitude | Numerical extrapolation with attitude simulation
*DefaultApi* | [**compute_numerical_extrapolation_without_attitude**](docs/DefaultApi.md#compute_numerical_extrapolation_without_attitude) | **POST** /extrapolation/numerical-without-attitude | Numerical extrapolation without attitude simulation
*DefaultApi* | [**compute_tle_extrapolation**](docs/DefaultApi.md#compute_tle_extrapolation) | **POST** /extrapolation/tle | TLE extrapolation


## Documentation For Models

 - [AnomalyType](docs/AnomalyType.md)
 - [AtmosphereModel](docs/AtmosphereModel.md)
 - [AtmosphereType](docs/AtmosphereType.md)
 - [AtmosphericDragPerturbation](docs/AtmosphericDragPerturbation.md)
 - [AttitudeBasedFiniteThrustSchedule](docs/AttitudeBasedFiniteThrustSchedule.md)
 - [AttitudeEphemeris](docs/AttitudeEphemeris.md)
 - [AttitudeEphemerisRequest](docs/AttitudeEphemerisRequest.md)
 - [AttitudeLaw](docs/AttitudeLaw.md)
 - [AttitudeLawType](docs/AttitudeLawType.md)
 - [AttitudeRepresentationType](docs/AttitudeRepresentationType.md)
 - [AttitudeSequence](docs/AttitudeSequence.md)
 - [AttitudeSequenceType](docs/AttitudeSequenceType.md)
 - [BatteryModel](docs/BatteryModel.md)
 - [BatteryPowerEphemeris](docs/BatteryPowerEphemeris.md)
 - [BatteryPowerEphemerisRequest](docs/BatteryPowerEphemerisRequest.md)
 - [BoxObject](docs/BoxObject.md)
 - [BoxObjectProperties](docs/BoxObjectProperties.md)
 - [BoxObjectWithThrusterOnly](docs/BoxObjectWithThrusterOnly.md)
 - [CardanAngleEphemeris](docs/CardanAngleEphemeris.md)
 - [CartesianCovarianceEphemeris](docs/CartesianCovarianceEphemeris.md)
 - [CartesianCovarianceEphemerisRequest](docs/CartesianCovarianceEphemerisRequest.md)
 - [CartesianCovarianceFrameId](docs/CartesianCovarianceFrameId.md)
 - [CartesianCovarianceMatrix](docs/CartesianCovarianceMatrix.md)
 - [CartesianEphemeris](docs/CartesianEphemeris.md)
 - [CartesianEphemerisRequest](docs/CartesianEphemerisRequest.md)
 - [CartesianOrbit](docs/CartesianOrbit.md)
 - [CelestialBodyName](docs/CelestialBodyName.md)
 - [CelestialRelativePositionEphemeris](docs/CelestialRelativePositionEphemeris.md)
 - [CelestialRelativePositionEphemerisRequest](docs/CelestialRelativePositionEphemerisRequest.md)
 - [CircularFieldOfView](docs/CircularFieldOfView.md)
 - [CircularOrbit](docs/CircularOrbit.md)
 - [ClosestApproachDefinition](docs/ClosestApproachDefinition.md)
 - [ClosestApproachEventLog](docs/ClosestApproachEventLog.md)
 - [ConjunctionEventRequest](docs/ConjunctionEventRequest.md)
 - [ConjunctionEventTypes](docs/ConjunctionEventTypes.md)
 - [CovarianceOrbitType](docs/CovarianceOrbitType.md)
 - [CustomGridConfiguration](docs/CustomGridConfiguration.md)
 - [DateTriggeredAttitude](docs/DateTriggeredAttitude.md)
 - [DateTriggeredAttitudeSequence](docs/DateTriggeredAttitudeSequence.md)
 - [DatedLocalFrameFiniteThrustDirection](docs/DatedLocalFrameFiniteThrustDirection.md)
 - [DatedLocalFrameImpulse](docs/DatedLocalFrameImpulse.md)
 - [EarthCenteredFrameId](docs/EarthCenteredFrameId.md)
 - [EarthCenteredFrameType](docs/EarthCenteredFrameType.md)
 - [EarthFixedFrameId](docs/EarthFixedFrameId.md)
 - [EarthOccultationType](docs/EarthOccultationType.md)
 - [EarthOrientedManeuverAttitudeLaw](docs/EarthOrientedManeuverAttitudeLaw.md)
 - [EarthPotentialPerturbation](docs/EarthPotentialPerturbation.md)
 - [EllipsoidId](docs/EllipsoidId.md)
 - [Ephemeris](docs/Ephemeris.md)
 - [EphemerisGenerationRequest](docs/EphemerisGenerationRequest.md)
 - [EphemerisGenerationRequests](docs/EphemerisGenerationRequests.md)
 - [EphemerisGenerationRequestsWithAttitude](docs/EphemerisGenerationRequestsWithAttitude.md)
 - [EphemerisGenerationRequestsWithoutAttitude](docs/EphemerisGenerationRequestsWithoutAttitude.md)
 - [EphemerisTimeGridConfiguration](docs/EphemerisTimeGridConfiguration.md)
 - [EphemerisWithAttitude](docs/EphemerisWithAttitude.md)
 - [EphemerisWithoutAttitude](docs/EphemerisWithoutAttitude.md)
 - [EquinoctialOrbit](docs/EquinoctialOrbit.md)
 - [EventDetectionType](docs/EventDetectionType.md)
 - [EventGenerationRequest](docs/EventGenerationRequest.md)
 - [EventGenerationRequests](docs/EventGenerationRequests.md)
 - [EventGenerationRequestsWithAttitude](docs/EventGenerationRequestsWithAttitude.md)
 - [EventGenerationRequestsWithoutAttitude](docs/EventGenerationRequestsWithoutAttitude.md)
 - [EventLogs](docs/EventLogs.md)
 - [EventLogsWithAttitude](docs/EventLogsWithAttitude.md)
 - [EventLogsWithoutAttitude](docs/EventLogsWithoutAttitude.md)
 - [ExtrapolationRequestCommonFields](docs/ExtrapolationRequestCommonFields.md)
 - [FieldDescription](docs/FieldDescription.md)
 - [FieldOfView](docs/FieldOfView.md)
 - [FieldOfViewEventLog](docs/FieldOfViewEventLog.md)
 - [FieldOfViewEventRequest](docs/FieldOfViewEventRequest.md)
 - [FieldOfViewEventTypes](docs/FieldOfViewEventTypes.md)
 - [FieldOfViewType](docs/FieldOfViewType.md)
 - [FinalCartesianCovarianceConfiguration](docs/FinalCartesianCovarianceConfiguration.md)
 - [FinalCovarianceConfiguration](docs/FinalCovarianceConfiguration.md)
 - [FinalOrbitConfiguration](docs/FinalOrbitConfiguration.md)
 - [FinalOrbitalElementsCovarianceConfiguration](docs/FinalOrbitalElementsCovarianceConfiguration.md)
 - [FiniteThrustDefinition](docs/FiniteThrustDefinition.md)
 - [FixedStepIntegratorConfiguration](docs/FixedStepIntegratorConfiguration.md)
 - [FixedStepIntegratorType](docs/FixedStepIntegratorType.md)
 - [GeodeticEphemeris](docs/GeodeticEphemeris.md)
 - [GeodeticEphemerisRequest](docs/GeodeticEphemerisRequest.md)
 - [GroundLocation](docs/GroundLocation.md)
 - [GroundStation](docs/GroundStation.md)
 - [HarrisPriesterAtmosphere](docs/HarrisPriesterAtmosphere.md)
 - [InertialFrameId](docs/InertialFrameId.md)
 - [IntegratorConfiguration](docs/IntegratorConfiguration.md)
 - [IntegratorType](docs/IntegratorType.md)
 - [InterpolatedLocalFrameAttitudeLaw](docs/InterpolatedLocalFrameAttitudeLaw.md)
 - [IsotropicObject](docs/IsotropicObject.md)
 - [KeplerianOrbit](docs/KeplerianOrbit.md)
 - [LocalFrameAttitudeLaw](docs/LocalFrameAttitudeLaw.md)
 - [LocalFrameBasedFiniteThrustSequence](docs/LocalFrameBasedFiniteThrustSequence.md)
 - [LocalFrameBasedImpulsiveSequence](docs/LocalFrameBasedImpulsiveSequence.md)
 - [LocalFrameBasedManeuverSchedule](docs/LocalFrameBasedManeuverSchedule.md)
 - [LocalFrameBasedManeuverSequence](docs/LocalFrameBasedManeuverSequence.md)
 - [LocalFrameBasedManeuverSequenceType](docs/LocalFrameBasedManeuverSequenceType.md)
 - [ManeuverDirectionType](docs/ManeuverDirectionType.md)
 - [ManeuverExecutionReport](docs/ManeuverExecutionReport.md)
 - [ManeuverPlanCommonFields](docs/ManeuverPlanCommonFields.md)
 - [ManeuverSchedule](docs/ManeuverSchedule.md)
 - [ManeuverScheduleType](docs/ManeuverScheduleType.md)
 - [ManeuverTarget](docs/ManeuverTarget.md)
 - [ManeuverTargetElementsDelta](docs/ManeuverTargetElementsDelta.md)
 - [ManeuverTargetElementsValue](docs/ManeuverTargetElementsValue.md)
 - [ManeuverTargetType](docs/ManeuverTargetType.md)
 - [MassEphemeris](docs/MassEphemeris.md)
 - [MassEphemerisRequest](docs/MassEphemerisRequest.md)
 - [MeanOrbitEphemeris](docs/MeanOrbitEphemeris.md)
 - [MeanOrbitEphemerisRequest](docs/MeanOrbitEphemerisRequest.md)
 - [MeanOsculatingOrbitType](docs/MeanOsculatingOrbitType.md)
 - [NadirPointingLaw](docs/NadirPointingLaw.md)
 - [NrlMsise00Atmosphere](docs/NrlMsise00Atmosphere.md)
 - [NumericalExtrapolationFinalState](docs/NumericalExtrapolationFinalState.md)
 - [NumericalExtrapolationRequestCommonFields](docs/NumericalExtrapolationRequestCommonFields.md)
 - [NumericalExtrapolationWithAttitudeSimulationFinalState](docs/NumericalExtrapolationWithAttitudeSimulationFinalState.md)
 - [NumericalExtrapolationWithAttitudeSimulationRequest](docs/NumericalExtrapolationWithAttitudeSimulationRequest.md)
 - [NumericalExtrapolationWithAttitudeSimulationResult](docs/NumericalExtrapolationWithAttitudeSimulationResult.md)
 - [NumericalExtrapolationWithoutAttitudeSimulationFinalState](docs/NumericalExtrapolationWithoutAttitudeSimulationFinalState.md)
 - [NumericalExtrapolationWithoutAttitudeSimulationRequest](docs/NumericalExtrapolationWithoutAttitudeSimulationRequest.md)
 - [NumericalExtrapolationWithoutAttitudeSimulationResult](docs/NumericalExtrapolationWithoutAttitudeSimulationResult.md)
 - [OemRequest](docs/OemRequest.md)
 - [Orbit](docs/Orbit.md)
 - [OrbitDataMessageFileFormat](docs/OrbitDataMessageFileFormat.md)
 - [OrbitType](docs/OrbitType.md)
 - [OrbitalCovarianceEphemeris](docs/OrbitalCovarianceEphemeris.md)
 - [OrbitalCovarianceEphemerisRequest](docs/OrbitalCovarianceEphemerisRequest.md)
 - [OrbitalCovarianceMatrix](docs/OrbitalCovarianceMatrix.md)
 - [OrbitalElementsCovarianceMatrix](docs/OrbitalElementsCovarianceMatrix.md)
 - [OrbitalEventFamilyType](docs/OrbitalEventFamilyType.md)
 - [OrbitalEventLog](docs/OrbitalEventLog.md)
 - [OrbitalEventRequest](docs/OrbitalEventRequest.md)
 - [OrbitalEventType](docs/OrbitalEventType.md)
 - [OrbitalParameterType](docs/OrbitalParameterType.md)
 - [OrbitalTransferWithoutPowerSystemFinalState](docs/OrbitalTransferWithoutPowerSystemFinalState.md)
 - [OrbitalTransferWithoutPowerSystemRequest](docs/OrbitalTransferWithoutPowerSystemRequest.md)
 - [OrbitalTransferWithoutPowerSystemResult](docs/OrbitalTransferWithoutPowerSystemResult.md)
 - [OsculatingOrbitEphemeris](docs/OsculatingOrbitEphemeris.md)
 - [OsculatingOrbitEphemerisRequest](docs/OsculatingOrbitEphemerisRequest.md)
 - [OsculatingToMeanConversionTheory](docs/OsculatingToMeanConversionTheory.md)
 - [OutputConfiguration](docs/OutputConfiguration.md)
 - [OutputCovarianceType](docs/OutputCovarianceType.md)
 - [Perturbation](docs/Perturbation.md)
 - [PerturbationType](docs/PerturbationType.md)
 - [ProblemDetail](docs/ProblemDetail.md)
 - [PropulsionSystem](docs/PropulsionSystem.md)
 - [QuaternionEphemeris](docs/QuaternionEphemeris.md)
 - [RadiationCoefficients](docs/RadiationCoefficients.md)
 - [RadiationCoefficientsType](docs/RadiationCoefficientsType.md)
 - [ReflectionAbsorptionCoefficients](docs/ReflectionAbsorptionCoefficients.md)
 - [RelativeCartesianEphemeris](docs/RelativeCartesianEphemeris.md)
 - [RelativeDistanceDefinition](docs/RelativeDistanceDefinition.md)
 - [RotatingLocalFrameId](docs/RotatingLocalFrameId.md)
 - [RotationConvention](docs/RotationConvention.md)
 - [RotationOrder](docs/RotationOrder.md)
 - [SecondaryObjectDefinition](docs/SecondaryObjectDefinition.md)
 - [SecondaryObjectEventDefinition](docs/SecondaryObjectEventDefinition.md)
 - [SecondaryObjectEventDefinitionType](docs/SecondaryObjectEventDefinitionType.md)
 - [SecondaryObjectEventLog](docs/SecondaryObjectEventLog.md)
 - [SecondaryObjectEventRequest](docs/SecondaryObjectEventRequest.md)
 - [SecondaryObjectEventTypes](docs/SecondaryObjectEventTypes.md)
 - [SecondaryPropagationType](docs/SecondaryPropagationType.md)
 - [SecondaryRelativeCartesianEphemeris](docs/SecondaryRelativeCartesianEphemeris.md)
 - [SecondaryRelativeCartesianEphemerisRequest](docs/SecondaryRelativeCartesianEphemerisRequest.md)
 - [SecondaryRelativeFrameType](docs/SecondaryRelativeFrameType.md)
 - [ShadowModelType](docs/ShadowModelType.md)
 - [SimulationConfiguration](docs/SimulationConfiguration.md)
 - [SimulationContextCommonFields](docs/SimulationContextCommonFields.md)
 - [SingleRadiationCoefficient](docs/SingleRadiationCoefficient.md)
 - [SolarArrayGeometry](docs/SolarArrayGeometry.md)
 - [SolarArraySystem](docs/SolarArraySystem.md)
 - [SolarRadiationPressurePerturbation](docs/SolarRadiationPressurePerturbation.md)
 - [SolidTidesPerturbation](docs/SolidTidesPerturbation.md)
 - [SpaceObject](docs/SpaceObject.md)
 - [SpaceObjectType](docs/SpaceObjectType.md)
 - [StationEventRequest](docs/StationEventRequest.md)
 - [StationEventTypes](docs/StationEventTypes.md)
 - [StationVisibilityEventLog](docs/StationVisibilityEventLog.md)
 - [SunEnhancedManeuverAttitudeLaw](docs/SunEnhancedManeuverAttitudeLaw.md)
 - [SunPointingLaw](docs/SunPointingLaw.md)
 - [TLE](docs/TLE.md)
 - [TargetCelestialBody](docs/TargetCelestialBody.md)
 - [TerrestrialRelativePositionEphemeris](docs/TerrestrialRelativePositionEphemeris.md)
 - [TerrestrialRelativePositionEphemerisRequest](docs/TerrestrialRelativePositionEphemerisRequest.md)
 - [ThirdBodiesGravityPerturbation](docs/ThirdBodiesGravityPerturbation.md)
 - [ThirdBodyName](docs/ThirdBodyName.md)
 - [ThrustVectorEphemeris](docs/ThrustVectorEphemeris.md)
 - [ThrustVectorEphemerisRequest](docs/ThrustVectorEphemerisRequest.md)
 - [Thruster](docs/Thruster.md)
 - [TimeSpan](docs/TimeSpan.md)
 - [TimestampedOutputData](docs/TimestampedOutputData.md)
 - [TleEphemeris](docs/TleEphemeris.md)
 - [TleEphemerisRequest](docs/TleEphemerisRequest.md)
 - [TleExtrapolationRequest](docs/TleExtrapolationRequest.md)
 - [TleExtrapolationResult](docs/TleExtrapolationResult.md)
 - [TwoLineElementOrbit](docs/TwoLineElementOrbit.md)
 - [UniformGridConfiguration](docs/UniformGridConfiguration.md)
 - [VariableStepIntegratorConfiguration](docs/VariableStepIntegratorConfiguration.md)
 - [VariableStepIntegratorType](docs/VariableStepIntegratorType.md)
 - [Vector3D](docs/Vector3D.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




