# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ManeuverExecutionReport(BaseModel):
    """
    A detailed report including metrics relating to the maneuver duration, consumption and maneuvering strategy 
    """ # noqa: E501
    simulation_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The entire simulation duration. Units [s] ", alias="simulationDuration")
    total_burns_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The cumulative duration of all the burns performed during the maneuver. Units [s] ", alias="totalBurnsDuration")
    average_thrust_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The average duration for the burns performed during the maneuver. Units [s] ", alias="averageThrustDuration")
    number_of_revolutions: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maneuver duration expressed as number of revolutions. Units [-] ", alias="numberOfRevolutions")
    total_number_of_burns: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units [-] ", alias="totalNumberOfBurns")
    total_consumption: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units [g] ", alias="totalConsumption")
    total_delta_v: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units [ms^-1] ", alias="totalDeltaV")
    total_impulse: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units [Ns] ", alias="totalImpulse")
    thruster_duty_cycle: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=None, description="The ratio between the total thrust duration and the simulation duration. ", alias="thrusterDutyCycle")
    final_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="finalDutyCycle")
    __properties: ClassVar[List[str]] = ["simulationDuration", "totalBurnsDuration", "averageThrustDuration", "numberOfRevolutions", "totalNumberOfBurns", "totalConsumption", "totalDeltaV", "totalImpulse", "thrusterDutyCycle", "finalDutyCycle"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ManeuverExecutionReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ManeuverExecutionReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "simulationDuration": obj.get("simulationDuration"),
            "totalBurnsDuration": obj.get("totalBurnsDuration"),
            "averageThrustDuration": obj.get("averageThrustDuration"),
            "numberOfRevolutions": obj.get("numberOfRevolutions"),
            "totalNumberOfBurns": obj.get("totalNumberOfBurns"),
            "totalConsumption": obj.get("totalConsumption"),
            "totalDeltaV": obj.get("totalDeltaV"),
            "totalImpulse": obj.get("totalImpulse"),
            "thrusterDutyCycle": obj.get("thrusterDutyCycle"),
            "finalDutyCycle": obj.get("finalDutyCycle")
        })
        return _obj


