# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.attitude_based_finite_thrust_schedule import AttitudeBasedFiniteThrustSchedule
from spacetower_orbit_extrapolation_python_client.models.attitude_sequence import AttitudeSequence
from spacetower_orbit_extrapolation_python_client.models.maneuver_execution_report import ManeuverExecutionReport
from typing import Optional, Set
from typing_extensions import Self

class ManeuverPlanCommonFields(BaseModel):
    """
    ManeuverPlanCommonFields
    """ # noqa: E501
    maneuver_schedule: Optional[AttitudeBasedFiniteThrustSchedule] = Field(default=None, alias="maneuverSchedule")
    attitude_sequence: Optional[AttitudeSequence] = Field(default=None, alias="attitudeSequence")
    maneuver_execution_report: Optional[ManeuverExecutionReport] = Field(default=None, alias="maneuverExecutionReport")
    data: Optional[Dict[str, StrictStr]] = Field(default=None, description="References to the data used during the computation")
    __properties: ClassVar[List[str]] = ["maneuverSchedule", "attitudeSequence", "maneuverExecutionReport", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ManeuverPlanCommonFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of maneuver_schedule
        if self.maneuver_schedule:
            _dict['maneuverSchedule'] = self.maneuver_schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attitude_sequence
        if self.attitude_sequence:
            _dict['attitudeSequence'] = self.attitude_sequence.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maneuver_execution_report
        if self.maneuver_execution_report:
            _dict['maneuverExecutionReport'] = self.maneuver_execution_report.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ManeuverPlanCommonFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "maneuverSchedule": AttitudeBasedFiniteThrustSchedule.from_dict(obj["maneuverSchedule"]) if obj.get("maneuverSchedule") is not None else None,
            "attitudeSequence": AttitudeSequence.from_dict(obj["attitudeSequence"]) if obj.get("attitudeSequence") is not None else None,
            "maneuverExecutionReport": ManeuverExecutionReport.from_dict(obj["maneuverExecutionReport"]) if obj.get("maneuverExecutionReport") is not None else None,
            "data": obj.get("data")
        })
        return _obj


