# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from spacetower_orbit_extrapolation_python_client.models.anomaly_type import AnomalyType
from spacetower_orbit_extrapolation_python_client.models.covariance_orbit_type import CovarianceOrbitType
from spacetower_orbit_extrapolation_python_client.models.inertial_frame_id import InertialFrameId
from spacetower_orbit_extrapolation_python_client.models.orbital_covariance_matrix import OrbitalCovarianceMatrix
from typing import Optional, Set
from typing_extensions import Self

class OrbitalElementsCovarianceMatrix(OrbitalCovarianceMatrix):
    """
    Covariance matrix expressed in terms of orbital elements. The upper triangular part of the <br> matrix is expected. Angular values have to be entered in radians.
    """ # noqa: E501
    inertial_frame_id: Optional[InertialFrameId] = Field(default=None, alias="inertialFrameId")
    anomaly_type: Optional[AnomalyType] = Field(default=None, alias="anomalyType")
    matrix_first_row: Annotated[List[Union[StrictFloat, StrictInt]], Field(min_length=6, max_length=6)] = Field(description="Elements [1,1] through [1,6] of the covariance matrix: - ``KEPLERIAN``: [sma-var[m^2], sma-ecc-cov[m], sma-inc-cov[m\\*rad], sma-aop-cov[m\\*rad], sma-raan-cov[m\\*rad], sma-mean/true/eccentric-an-cov[m\\*rad]] - ``CIRCULAR``: [sma-var[m^2], sma-ex-cov[m], sma-ey-cov[m], sma-inc-cov[m\\*rad], sma-raan-cov[m\\*rad], sma-mean/true/eccentric-aol-cov[m\\*rad]] - ``EQUINOCTIAL``: [sma-var[m^2], sma-ex-cov[m], sma-ey-cov[m], sma-hx-cov[m], sma-hy-cov[m], sma-mean/true/eccentric-lon-cov[m\\*rad]] ", alias="matrixFirstRow")
    matrix_second_row: Annotated[List[Union[StrictFloat, StrictInt]], Field(min_length=5, max_length=5)] = Field(description="Elements [2,2] through [2,6] of the covariance matrix: - ``KEPLERIAN``: [ecc-var[-],     ecc-inc-cov[rad],    ecc-aop-cov[rad],    ecc-raan-cov[rad],    ecc-mean/true/eccentric-an-cov[rad]] - ``CIRCULAR``: [ex-var[-],     ex-ey-cov[-],  ex-inc-cov[rad],     ex-raan-cov[rad],     ex-mean/true/eccentric-aol-cov[rad]] - ``EQUINOCTIAL``: [ex-var[-],     ex-ey-cov[-],  ex-hx-cov[-],  ex-hy-cov[-],  ex-mean/true/eccentric-lon-cov[rad]] ", alias="matrixSecondRow")
    matrix_third_row: Annotated[List[Union[StrictFloat, StrictInt]], Field(min_length=4, max_length=4)] = Field(description="Elements [3,3] through [3,6] of the covariance matrix: - ``KEPLERIAN``: [inc-var[rad^2],      inc-aop-cov[rad^2],  inc-raan-cov[rad^2],  inc-mean/true/eccentric-an-cov[rad^2]] - ``CIRCULAR``: [ey-var[-],     ey-inc-cov[rad],     ey-raan-cov[rad],     ey-mean/true/eccentric-aol-cov[rad]] - ``EQUINOCTIAL``: [ey-var[-],     ey-hx-cov[-],  ey-hy-cov[-],  ey-mean/true/eccentric-lon-cov[rad]] ", alias="matrixThirdRow")
    matrix_fourth_row: Annotated[List[Union[StrictFloat, StrictInt]], Field(min_length=3, max_length=3)] = Field(description="Elements [4,4] through [4,6] of the covariance matrix: - ``KEPLERIAN``: [aop-var[rad^2],      aop-raan-cov[rad^2],  aop-mean/true/eccentric-an-cov[rad^2]] - ``CIRCULAR``: [inc-var[rad^2],      inc-raan-cov[rad^2],  inc-mean/true/eccentric-aol-cov[rad^2]] - ``EQUINOCTIAL``: [hx-var[-],     hx-hy-cov[-],  hx-mean/true/eccentric-lon-cov[rad]] ", alias="matrixFourthRow")
    matrix_fifth_row: Annotated[List[Union[StrictFloat, StrictInt]], Field(min_length=2, max_length=2)] = Field(description="Elements [5,5] and [5,6] of the covariance matrix: - ``KEPLERIAN``: [raan-var[rad^2],      raan-mean/true/eccentric-an-cov[rad^2]] - ``CIRCULAR``: [raan-var[rad^2],      raan-mean/true/eccentric-aol-cov[rad^2]] - ``EQUINOCTIAL``: [hy-var[-],     hy-mean/true/eccentric-lon-cov[rad]] ", alias="matrixFifthRow")
    matrix_sixth_row: Annotated[List[Union[StrictFloat, StrictInt]], Field(min_length=1, max_length=1)] = Field(description="Element [6,6] of the covariance matrix:  - ``KEPLERIAN``: [mean/true/eccentric-an-var[rad^2]] - ``CIRCULAR``: [mean/true/eccentric-aol-var[rad^2]] - ``EQUINOCTIAL``: [mean/true/eccentric-lon-var[rad^2]] ", alias="matrixSixthRow")
    __properties: ClassVar[List[str]] = ["covarianceOrbitType", "inertialFrameId", "anomalyType", "matrixFirstRow", "matrixSecondRow", "matrixThirdRow", "matrixFourthRow", "matrixFifthRow", "matrixSixthRow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitalElementsCovarianceMatrix from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitalElementsCovarianceMatrix from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "covarianceOrbitType": obj.get("covarianceOrbitType"),
            "inertialFrameId": obj.get("inertialFrameId"),
            "anomalyType": obj.get("anomalyType"),
            "matrixFirstRow": obj.get("matrixFirstRow"),
            "matrixSecondRow": obj.get("matrixSecondRow"),
            "matrixThirdRow": obj.get("matrixThirdRow"),
            "matrixFourthRow": obj.get("matrixFourthRow"),
            "matrixFifthRow": obj.get("matrixFifthRow"),
            "matrixSixthRow": obj.get("matrixSixthRow")
        })
        return _obj


