# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.attitude_representation_type import AttitudeRepresentationType
from spacetower_orbit_extrapolation_python_client.models.field_description import FieldDescription
from spacetower_orbit_extrapolation_python_client.models.inertial_frame_id import InertialFrameId
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_extrapolation_python_client.models.cardan_angle_ephemeris import CardanAngleEphemeris
    from spacetower_orbit_extrapolation_python_client.models.quaternion_ephemeris import QuaternionEphemeris

class AttitudeEphemeris(BaseModel):
    """
    Ephemeris of attitude from some frame to Satellite frame
    """ # noqa: E501
    dates: List[str] = Field(description="The UTC dates of the data points")
    description: Optional[List[FieldDescription]] = Field(default=None, description="List of each metric outputted and how to identify them in each entry (DataEntry corresponding to a date) of the data array")
    inertial_frame_id: Optional[InertialFrameId] = Field(default=None, alias="inertialFrameId")
    attitude_representation_type: AttitudeRepresentationType = Field(alias="attitudeRepresentationType")
    __properties: ClassVar[List[str]] = ["dates", "description", "inertialFrameId", "attitudeRepresentationType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'attitudeRepresentationType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'CARDAN_TNW_SAT': 'CardanAngleEphemeris','QUAT_ECI_SAT': 'QuaternionEphemeris'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[CardanAngleEphemeris, QuaternionEphemeris]]:
        """Create an instance of AttitudeEphemeris from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item in self.description:
                if _item:
                    _items.append(_item.to_dict())
            _dict['description'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[CardanAngleEphemeris, QuaternionEphemeris]]:
        """Create an instance of AttitudeEphemeris from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'CardanAngleEphemeris':
            return import_module("spacetower_orbit_extrapolation_python_client.models.cardan_angle_ephemeris").CardanAngleEphemeris.from_dict(obj)
        if object_type ==  'QuaternionEphemeris':
            return import_module("spacetower_orbit_extrapolation_python_client.models.quaternion_ephemeris").QuaternionEphemeris.from_dict(obj)

        raise ValueError("AttitudeEphemeris failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


