# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.4.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from spacetower_orbit_extrapolation_python_client.models.box_geometry import BoxGeometry
from spacetower_orbit_extrapolation_python_client.models.reflection_absorption_coefficients import ReflectionAbsorptionCoefficients
from spacetower_orbit_extrapolation_python_client.models.solar_array_geometry import SolarArrayGeometry
from typing import Optional, Set
from typing_extensions import Self

class BoxObjectBase(BaseModel):
    """
    Base for box-shaped objects
    """ # noqa: E501
    box_geometry: Optional[BoxGeometry] = Field(default=None, alias="boxGeometry")
    x_dimension: Optional[Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]]] = Field(default=1, description="Box dimension along X axis. Units [m]", alias="xDimension")
    y_dimension: Optional[Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]]] = Field(default=1, description="Box dimension along Y axis. Units [m]", alias="yDimension")
    z_dimension: Optional[Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]]] = Field(default=1, description="Box dimension along Z axis. Units [m]", alias="zDimension")
    radiation_coefficients: Optional[ReflectionAbsorptionCoefficients] = Field(default=None, alias="radiationCoefficients")
    solar_array_geometry: SolarArrayGeometry = Field(alias="solarArrayGeometry")
    radiation_correction_factor: Optional[Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]]] = Field(default=1, description="Correction factor for the radiation pressure acceleration. Units [-]", alias="radiationCorrectionFactor")
    __properties: ClassVar[List[str]] = ["boxGeometry", "xDimension", "yDimension", "zDimension", "radiationCoefficients", "solarArrayGeometry", "radiationCorrectionFactor"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BoxObjectBase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of box_geometry
        if self.box_geometry:
            _dict['boxGeometry'] = self.box_geometry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of radiation_coefficients
        if self.radiation_coefficients:
            _dict['radiationCoefficients'] = self.radiation_coefficients.to_dict()
        # override the default output from pydantic by calling `to_dict()` of solar_array_geometry
        if self.solar_array_geometry:
            _dict['solarArrayGeometry'] = self.solar_array_geometry.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BoxObjectBase from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "boxGeometry": BoxGeometry.from_dict(obj["boxGeometry"]) if obj.get("boxGeometry") is not None else None,
            "xDimension": obj.get("xDimension") if obj.get("xDimension") is not None else 1,
            "yDimension": obj.get("yDimension") if obj.get("yDimension") is not None else 1,
            "zDimension": obj.get("zDimension") if obj.get("zDimension") is not None else 1,
            "radiationCoefficients": ReflectionAbsorptionCoefficients.from_dict(obj["radiationCoefficients"]) if obj.get("radiationCoefficients") is not None else None,
            "solarArrayGeometry": SolarArrayGeometry.from_dict(obj["solarArrayGeometry"]) if obj.get("solarArrayGeometry") is not None else None,
            "radiationCorrectionFactor": obj.get("radiationCorrectionFactor") if obj.get("radiationCorrectionFactor") is not None else 1
        })
        return _obj


