# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_python_client.models.quaternion_action_dto import QuaternionActionDto
from typing import Optional, Set
from typing_extensions import Self

class AttitudeActionDto(BaseModel):
    """
    AttitudeActionDto
    """ # noqa: E501
    attitude_mode: StrictStr = Field(description="Attitude list, can contains quaternions", alias="attitudeMode")
    id: Optional[StrictStr] = None
    quaternions: Optional[List[QuaternionActionDto]] = Field(default=None, description="List of quaternions related to the current attitude. Required if attitudeMode is QUATERNION")
    transition_date: StrictStr = Field(description="UTC date", alias="transitionDate")
    __properties: ClassVar[List[str]] = ["attitudeMode", "id", "quaternions", "transitionDate"]

    @field_validator('attitude_mode')
    def attitude_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['PROGRADE', 'RETROGRADE', 'NORMAL', 'ANTI_NORMAL', 'RADIAL', 'ANTI_RADIAL', 'QUATERNION', 'NONE', 'SUN_POINTING', 'TELECOM', 'PAYLOAD', 'TRANSITIONAL', 'LOF_ALIGNED_LVLH_CCSDS', 'RETROGRADE_NADIR']):
            raise ValueError("must be one of enum values ('PROGRADE', 'RETROGRADE', 'NORMAL', 'ANTI_NORMAL', 'RADIAL', 'ANTI_RADIAL', 'QUATERNION', 'NONE', 'SUN_POINTING', 'TELECOM', 'PAYLOAD', 'TRANSITIONAL', 'LOF_ALIGNED_LVLH_CCSDS', 'RETROGRADE_NADIR')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AttitudeActionDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in quaternions (list)
        _items = []
        if self.quaternions:
            for _item in self.quaternions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['quaternions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AttitudeActionDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attitudeMode": obj.get("attitudeMode"),
            "id": obj.get("id"),
            "quaternions": [QuaternionActionDto.from_dict(_item) for _item in obj["quaternions"]] if obj.get("quaternions") is not None else None,
            "transitionDate": obj.get("transitionDate")
        })
        return _obj


