# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ChemicalThrusterDto(BaseModel):
    """
    ChemicalThrusterDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    impulse: Union[StrictFloat, StrictInt] = Field(description="Units: [Ns]")
    maximum_thrust_duration: Union[StrictFloat, StrictInt] = Field(description="Units: [s]", alias="maximumThrustDuration")
    propellant_mass: Union[StrictFloat, StrictInt] = Field(description="Units: [kg]", alias="propellantMass")
    thrust: Union[StrictFloat, StrictInt] = Field(description="Units: [N]")
    thruster_axis_in_satellite_frame: List[Union[StrictFloat, StrictInt]] = Field(alias="thrusterAxisInSatelliteFrame")
    thruster_isp: Union[StrictFloat, StrictInt] = Field(description="Units: [s]", alias="thrusterIsp")
    thruster_total_mass: Union[StrictFloat, StrictInt] = Field(description="Wet mass. Units: [kg]", alias="thrusterTotalMass")
    warm_up_duration: Union[StrictFloat, StrictInt] = Field(description="Units: [s]", alias="warmUpDuration")
    __properties: ClassVar[List[str]] = ["id", "impulse", "maximumThrustDuration", "propellantMass", "thrust", "thrusterAxisInSatelliteFrame", "thrusterIsp", "thrusterTotalMass", "warmUpDuration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChemicalThrusterDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChemicalThrusterDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "impulse": obj.get("impulse"),
            "maximumThrustDuration": obj.get("maximumThrustDuration"),
            "propellantMass": obj.get("propellantMass"),
            "thrust": obj.get("thrust"),
            "thrusterAxisInSatelliteFrame": obj.get("thrusterAxisInSatelliteFrame"),
            "thrusterIsp": obj.get("thrusterIsp"),
            "thrusterTotalMass": obj.get("thrusterTotalMass"),
            "warmUpDuration": obj.get("warmUpDuration")
        })
        return _obj


