# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_python_client.models.ephemeris_request_dto import EphemerisRequestDto
from spacetower_python_client.models.orbital_state_dto import OrbitalStateDto
from typing import Optional, Set
from typing_extensions import Self

class OrbitExtrapolationOutputDto(BaseModel):
    """
    OrbitExtrapolationOutputDto
    """ # noqa: E501
    ephemeris_request: Optional[EphemerisRequestDto] = Field(default=None, alias="ephemerisRequest")
    events_requests: Optional[List[Dict[str, Any]]] = Field(default=None, alias="eventsRequests")
    extrapolate_covariance: Optional[StrictBool] = Field(default=None, alias="extrapolateCovariance")
    extrapolation_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="extrapolationDuration")
    id: Optional[StrictStr] = None
    initial_orbital_state: Optional[OrbitalStateDto] = Field(default=None, alias="initialOrbitalState")
    measurements_request: Optional[Dict[str, Any]] = Field(default=None, alias="measurementsRequest")
    orbit_data_message_request: Optional[Dict[str, Any]] = Field(default=None, alias="orbitDataMessageRequest")
    required_output_orbital_states: Optional[StrictStr] = Field(default=None, alias="requiredOutputOrbitalStates")
    roadmap: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["ephemerisRequest", "eventsRequests", "extrapolateCovariance", "extrapolationDuration", "id", "initialOrbitalState", "measurementsRequest", "orbitDataMessageRequest", "requiredOutputOrbitalStates", "roadmap"]

    @field_validator('required_output_orbital_states')
    def required_output_orbital_states_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ALL', 'LAST']):
            raise ValueError("must be one of enum values ('ALL', 'LAST')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitExtrapolationOutputDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ephemeris_request
        if self.ephemeris_request:
            _dict['ephemerisRequest'] = self.ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_orbital_state
        if self.initial_orbital_state:
            _dict['initialOrbitalState'] = self.initial_orbital_state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitExtrapolationOutputDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ephemerisRequest": EphemerisRequestDto.from_dict(obj["ephemerisRequest"]) if obj.get("ephemerisRequest") is not None else None,
            "eventsRequests": obj.get("eventsRequests"),
            "extrapolateCovariance": obj.get("extrapolateCovariance"),
            "extrapolationDuration": obj.get("extrapolationDuration"),
            "id": obj.get("id"),
            "initialOrbitalState": OrbitalStateDto.from_dict(obj["initialOrbitalState"]) if obj.get("initialOrbitalState") is not None else None,
            "measurementsRequest": obj.get("measurementsRequest"),
            "orbitDataMessageRequest": obj.get("orbitDataMessageRequest"),
            "requiredOutputOrbitalStates": obj.get("requiredOutputOrbitalStates"),
            "roadmap": obj.get("roadmap")
        })
        return _obj


