# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class RadarMeasurementsRequestDto(BaseModel):
    """
    RadarMeasurementsRequestDto
    """ # noqa: E501
    azimuth_standard_deviation: Union[StrictFloat, StrictInt] = Field(description="Units: [deg]", alias="azimuthStandardDeviation")
    elevation_standard_deviation: Union[StrictFloat, StrictInt] = Field(description="Units: [deg]", alias="elevationStandardDeviation")
    generation_step: StrictInt = Field(description="Units: [s]", alias="generationStep")
    ground_station_id: StrictStr = Field(description="The UUID of the tracking station", alias="groundStationId")
    id: Optional[StrictStr] = None
    range_rate_standard_deviation: Union[StrictFloat, StrictInt] = Field(description="Units: [m/s]", alias="rangeRateStandardDeviation")
    range_standard_deviation: Union[StrictFloat, StrictInt] = Field(description="Units: [m]", alias="rangeStandardDeviation")
    two_way_measurement: StrictBool = Field(description="True for a two way signal", alias="twoWayMeasurement")
    __properties: ClassVar[List[str]] = ["azimuthStandardDeviation", "elevationStandardDeviation", "generationStep", "groundStationId", "id", "rangeRateStandardDeviation", "rangeStandardDeviation", "twoWayMeasurement"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RadarMeasurementsRequestDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RadarMeasurementsRequestDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "azimuthStandardDeviation": obj.get("azimuthStandardDeviation"),
            "elevationStandardDeviation": obj.get("elevationStandardDeviation"),
            "generationStep": obj.get("generationStep"),
            "groundStationId": obj.get("groundStationId"),
            "id": obj.get("id"),
            "rangeRateStandardDeviation": obj.get("rangeRateStandardDeviation"),
            "rangeStandardDeviation": obj.get("rangeStandardDeviation"),
            "twoWayMeasurement": obj.get("twoWayMeasurement")
        })
        return _obj


