# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class SolarArrayDto(BaseModel):
    """
    SolarArrayDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    maximum_power: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units: [W]", alias="maximumPower")
    satellite_faces: Optional[List[StrictStr]] = Field(default=None, alias="satelliteFaces")
    solar_array_axis_in_satellite_frame: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, alias="solarArrayAxisInSatelliteFrame")
    solar_array_definition_type: StrictStr = Field(alias="solarArrayDefinitionType")
    solar_array_efficiency: Union[StrictFloat, StrictInt] = Field(description="x in (0,1), Units: [-]", alias="solarArrayEfficiency")
    solar_array_normal_in_satellite_frame: List[Union[StrictFloat, StrictInt]] = Field(alias="solarArrayNormalInSatelliteFrame")
    solar_array_type: StrictStr = Field(alias="solarArrayType")
    surface: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units: [m²]")
    __properties: ClassVar[List[str]] = ["id", "maximumPower", "satelliteFaces", "solarArrayAxisInSatelliteFrame", "solarArrayDefinitionType", "solarArrayEfficiency", "solarArrayNormalInSatelliteFrame", "solarArrayType", "surface"]

    @field_validator('satellite_faces')
    def satellite_faces_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['PLUS_X', 'MINUS_X', 'PLUS_Y', 'MINUS_Y', 'PLUS_Z', 'MINUS_Z']):
                raise ValueError("each list item must be one of ('PLUS_X', 'MINUS_X', 'PLUS_Y', 'MINUS_Y', 'PLUS_Z', 'MINUS_Z')")
        return value

    @field_validator('solar_array_definition_type')
    def solar_array_definition_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['MAXIMUM_POWER', 'SURFACE', 'SURFACE_AND_POWER']):
            raise ValueError("must be one of enum values ('MAXIMUM_POWER', 'SURFACE', 'SURFACE_AND_POWER')")
        return value

    @field_validator('solar_array_type')
    def solar_array_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SOLAR_ARRAY_TYPE_BODY', 'SOLAR_ARRAY_TYPE_DEPLOYABLE_FIXED', 'SOLAR_ARRAY_TYPE_DEPLOYABLE_ROTATING', 'SOLAR_ARRAY_TYPE_NONE']):
            raise ValueError("must be one of enum values ('SOLAR_ARRAY_TYPE_BODY', 'SOLAR_ARRAY_TYPE_DEPLOYABLE_FIXED', 'SOLAR_ARRAY_TYPE_DEPLOYABLE_ROTATING', 'SOLAR_ARRAY_TYPE_NONE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SolarArrayDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SolarArrayDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "maximumPower": obj.get("maximumPower"),
            "satelliteFaces": obj.get("satelliteFaces"),
            "solarArrayAxisInSatelliteFrame": obj.get("solarArrayAxisInSatelliteFrame"),
            "solarArrayDefinitionType": obj.get("solarArrayDefinitionType"),
            "solarArrayEfficiency": obj.get("solarArrayEfficiency"),
            "solarArrayNormalInSatelliteFrame": obj.get("solarArrayNormalInSatelliteFrame"),
            "solarArrayType": obj.get("solarArrayType"),
            "surface": obj.get("surface")
        })
        return _obj


