# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.6
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_python_client.models.maneuver_generation_log_dto import ManeuverGenerationLogDto
from spacetower_python_client.models.maneuver_generation_output_dto import ManeuverGenerationOutputDto
from spacetower_python_client.models.maneuver_generation_report_dto import ManeuverGenerationReportDto
from typing import Optional, Set
from typing_extensions import Self

class ManeuverGenerationResultDto(BaseModel):
    """
    ManeuverGenerationResultDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    log: Optional[ManeuverGenerationLogDto] = None
    report: Optional[ManeuverGenerationReportDto] = None
    request: Optional[ManeuverGenerationOutputDto] = None
    roadmap: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["id", "log", "report", "request", "roadmap"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ManeuverGenerationResultDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of log
        if self.log:
            _dict['log'] = self.log.to_dict()
        # override the default output from pydantic by calling `to_dict()` of report
        if self.report:
            _dict['report'] = self.report.to_dict()
        # override the default output from pydantic by calling `to_dict()` of request
        if self.request:
            _dict['request'] = self.request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ManeuverGenerationResultDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "log": ManeuverGenerationLogDto.from_dict(obj["log"]) if obj.get("log") is not None else None,
            "report": ManeuverGenerationReportDto.from_dict(obj["report"]) if obj.get("report") is not None else None,
            "request": ManeuverGenerationOutputDto.from_dict(obj["request"]) if obj.get("request") is not None else None,
            "roadmap": obj.get("roadmap")
        })
        return _obj


