# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.6
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ManeuverStrategyDto(BaseModel):
    """
    ManeuverStrategyDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    number_of_rest_orbits: StrictInt = Field(description="Units: [-]", alias="numberOfRestOrbits")
    number_of_shift_orbits: StrictInt = Field(description="Units: [-]", alias="numberOfShiftOrbits")
    number_of_thrust_orbits: StrictInt = Field(description="Units: [-]", alias="numberOfThrustOrbits")
    orbital_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units: [%]", alias="orbitalDutyCycle")
    stop_thrust_at_eclipse: StrictBool = Field(alias="stopThrustAtEclipse")
    thrust_arc_definition: StrictStr = Field(alias="thrustArcDefinition")
    thrust_arc_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units: [s]", alias="thrustArcDuration")
    thrust_arcs_number: StrictStr = Field(alias="thrustArcsNumber")
    thrust_arcs_position: StrictStr = Field(alias="thrustArcsPosition")
    __properties: ClassVar[List[str]] = ["id", "numberOfRestOrbits", "numberOfShiftOrbits", "numberOfThrustOrbits", "orbitalDutyCycle", "stopThrustAtEclipse", "thrustArcDefinition", "thrustArcDuration", "thrustArcsNumber", "thrustArcsPosition"]

    @field_validator('thrust_arc_definition')
    def thrust_arc_definition_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['DUTY_CYCLE', 'THRUST_DURATION']):
            raise ValueError("must be one of enum values ('DUTY_CYCLE', 'THRUST_DURATION')")
        return value

    @field_validator('thrust_arcs_number')
    def thrust_arcs_number_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ONE', 'TWO']):
            raise ValueError("must be one of enum values ('ONE', 'TWO')")
        return value

    @field_validator('thrust_arcs_position')
    def thrust_arcs_position_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ASCENDING_AND_DESCENDING_NODES', 'ASCENDING_NODE', 'CUSTOM', 'DESCENDING_NODE', 'APOGEE_AND_PERIGEE', 'APOGEE', 'PERIGEE', 'ASCENDING_AND_DESCENDING_ANTINODES', 'ASCENDING_ANTINODE', 'DESCENDING_ANTINODE', 'MEAN_LONGITUDE']):
            raise ValueError("must be one of enum values ('ASCENDING_AND_DESCENDING_NODES', 'ASCENDING_NODE', 'CUSTOM', 'DESCENDING_NODE', 'APOGEE_AND_PERIGEE', 'APOGEE', 'PERIGEE', 'ASCENDING_AND_DESCENDING_ANTINODES', 'ASCENDING_ANTINODE', 'DESCENDING_ANTINODE', 'MEAN_LONGITUDE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ManeuverStrategyDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ManeuverStrategyDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "numberOfRestOrbits": obj.get("numberOfRestOrbits"),
            "numberOfShiftOrbits": obj.get("numberOfShiftOrbits"),
            "numberOfThrustOrbits": obj.get("numberOfThrustOrbits"),
            "orbitalDutyCycle": obj.get("orbitalDutyCycle"),
            "stopThrustAtEclipse": obj.get("stopThrustAtEclipse"),
            "thrustArcDefinition": obj.get("thrustArcDefinition"),
            "thrustArcDuration": obj.get("thrustArcDuration"),
            "thrustArcsNumber": obj.get("thrustArcsNumber"),
            "thrustArcsPosition": obj.get("thrustArcsPosition")
        })
        return _obj


