# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.6
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_python_client.models.residual_dto import ResidualDto
from typing import Optional, Set
from typing_extensions import Self

class OrbitDeterminationResidualStatisticsDto(BaseModel):
    """
    OrbitDeterminationResidualStatisticsDto
    """ # noqa: E501
    var_field: Optional[StrictStr] = Field(default=None, alias="field")
    id: Optional[StrictStr] = None
    mean: Optional[Union[StrictFloat, StrictInt]] = None
    median: Optional[Union[StrictFloat, StrictInt]] = None
    residuals: Optional[List[ResidualDto]] = None
    standard_deviation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="standardDeviation")
    __properties: ClassVar[List[str]] = ["field", "id", "mean", "median", "residuals", "standardDeviation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitDeterminationResidualStatisticsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in residuals (list)
        _items = []
        if self.residuals:
            for _item in self.residuals:
                if _item:
                    _items.append(_item.to_dict())
            _dict['residuals'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitDeterminationResidualStatisticsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "field": obj.get("field"),
            "id": obj.get("id"),
            "mean": obj.get("mean"),
            "median": obj.get("median"),
            "residuals": [ResidualDto.from_dict(_item) for _item in obj["residuals"]] if obj.get("residuals") is not None else None,
            "standardDeviation": obj.get("standardDeviation")
        })
        return _obj


