# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.6
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_python_client.models.firing_analysis_report_dto import FiringAnalysisReportDto
from spacetower_python_client.models.orbit_determination_in_depth_results_dto import OrbitDeterminationInDepthResultsDto
from spacetower_python_client.models.orbit_determination_log_dto import OrbitDeterminationLogDto
from spacetower_python_client.models.orbit_determination_report_dto import OrbitDeterminationReportDto
from spacetower_python_client.models.orbital_state_dto import OrbitalStateDto
from typing import Optional, Set
from typing_extensions import Self

class OrbitDeterminationResultDto(BaseModel):
    """
    OrbitDeterminationResultDto
    """ # noqa: E501
    estimated_keplerian_covariance: Optional[Dict[str, Any]] = Field(default=None, alias="estimatedKeplerianCovariance")
    estimated_states: Optional[List[OrbitalStateDto]] = Field(default=None, alias="estimatedStates")
    firing_analysis_report: Optional[FiringAnalysisReportDto] = Field(default=None, alias="firingAnalysisReport")
    id: Optional[StrictStr] = None
    in_depth_results: Optional[OrbitDeterminationInDepthResultsDto] = Field(default=None, alias="inDepthResults")
    log: Optional[OrbitDeterminationLogDto] = None
    report: Optional[OrbitDeterminationReportDto] = None
    request: Optional[Dict[str, Any]] = None
    status: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["estimatedKeplerianCovariance", "estimatedStates", "firingAnalysisReport", "id", "inDepthResults", "log", "report", "request", "status"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SUCCESS', 'ANALYSIS_NEEDED', 'FAILURE']):
            raise ValueError("must be one of enum values ('SUCCESS', 'ANALYSIS_NEEDED', 'FAILURE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitDeterminationResultDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in estimated_states (list)
        _items = []
        if self.estimated_states:
            for _item in self.estimated_states:
                if _item:
                    _items.append(_item.to_dict())
            _dict['estimatedStates'] = _items
        # override the default output from pydantic by calling `to_dict()` of firing_analysis_report
        if self.firing_analysis_report:
            _dict['firingAnalysisReport'] = self.firing_analysis_report.to_dict()
        # override the default output from pydantic by calling `to_dict()` of in_depth_results
        if self.in_depth_results:
            _dict['inDepthResults'] = self.in_depth_results.to_dict()
        # override the default output from pydantic by calling `to_dict()` of log
        if self.log:
            _dict['log'] = self.log.to_dict()
        # override the default output from pydantic by calling `to_dict()` of report
        if self.report:
            _dict['report'] = self.report.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitDeterminationResultDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "estimatedKeplerianCovariance": obj.get("estimatedKeplerianCovariance"),
            "estimatedStates": [OrbitalStateDto.from_dict(_item) for _item in obj["estimatedStates"]] if obj.get("estimatedStates") is not None else None,
            "firingAnalysisReport": FiringAnalysisReportDto.from_dict(obj["firingAnalysisReport"]) if obj.get("firingAnalysisReport") is not None else None,
            "id": obj.get("id"),
            "inDepthResults": OrbitDeterminationInDepthResultsDto.from_dict(obj["inDepthResults"]) if obj.get("inDepthResults") is not None else None,
            "log": OrbitDeterminationLogDto.from_dict(obj["log"]) if obj.get("log") is not None else None,
            "report": OrbitDeterminationReportDto.from_dict(obj["report"]) if obj.get("report") is not None else None,
            "request": obj.get("request"),
            "status": obj.get("status")
        })
        return _obj


