# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.6
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class OrbitExtrapolationInputDto(BaseModel):
    """
    OrbitExtrapolationInputDto
    """ # noqa: E501
    ephemeris_request_id: Optional[StrictStr] = Field(default=None, alias="ephemerisRequestId")
    events_request_ids: Optional[List[StrictStr]] = Field(default=None, alias="eventsRequestIds")
    extrapolate_covariance: Optional[StrictBool] = Field(default=None, description="Should the covariance be propagated. Default is false", alias="extrapolateCovariance")
    extrapolation_duration: Union[StrictFloat, StrictInt] = Field(description="Units: [s]", alias="extrapolationDuration")
    initial_orbital_state_id: StrictStr = Field(alias="initialOrbitalStateId")
    measurements_request_id: Optional[StrictStr] = Field(default=None, alias="measurementsRequestId")
    orbit_data_message_request_id: Optional[StrictStr] = Field(default=None, alias="orbitDataMessageRequestId")
    required_output_orbital_states: Optional[StrictStr] = Field(default=None, description="Which orbital states should be included in the output", alias="requiredOutputOrbitalStates")
    roadmap_id: Optional[StrictStr] = Field(default=None, alias="roadmapId")
    __properties: ClassVar[List[str]] = ["ephemerisRequestId", "eventsRequestIds", "extrapolateCovariance", "extrapolationDuration", "initialOrbitalStateId", "measurementsRequestId", "orbitDataMessageRequestId", "requiredOutputOrbitalStates", "roadmapId"]

    @field_validator('required_output_orbital_states')
    def required_output_orbital_states_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ALL', 'LAST']):
            raise ValueError("must be one of enum values ('ALL', 'LAST')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitExtrapolationInputDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitExtrapolationInputDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ephemerisRequestId": obj.get("ephemerisRequestId"),
            "eventsRequestIds": obj.get("eventsRequestIds"),
            "extrapolateCovariance": obj.get("extrapolateCovariance"),
            "extrapolationDuration": obj.get("extrapolationDuration"),
            "initialOrbitalStateId": obj.get("initialOrbitalStateId"),
            "measurementsRequestId": obj.get("measurementsRequestId"),
            "orbitDataMessageRequestId": obj.get("orbitDataMessageRequestId"),
            "requiredOutputOrbitalStates": obj.get("requiredOutputOrbitalStates"),
            "roadmapId": obj.get("roadmapId")
        })
        return _obj


