# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.6
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_python_client.models.ephemeris_dto import EphemerisDto
from spacetower_python_client.models.orbit_extrapolation_log_dto import OrbitExtrapolationLogDto
from spacetower_python_client.models.orbit_extrapolation_output_dto import OrbitExtrapolationOutputDto
from spacetower_python_client.models.orbital_state_dto import OrbitalStateDto
from typing import Optional, Set
from typing_extensions import Self

class OrbitExtrapolationResultDto(BaseModel):
    """
    OrbitExtrapolationResultDto
    """ # noqa: E501
    computed_events: Optional[List[Dict[str, Any]]] = Field(default=None, alias="computedEvents")
    computed_measurements: Optional[List[Dict[str, Any]]] = Field(default=None, alias="computedMeasurements")
    ephemerides: Optional[List[EphemerisDto]] = None
    id: Optional[StrictStr] = None
    log: Optional[OrbitExtrapolationLogDto] = None
    orbit_data_message_output: Optional[StrictStr] = Field(default=None, alias="orbitDataMessageOutput")
    orbital_states: Optional[List[OrbitalStateDto]] = Field(default=None, alias="orbitalStates")
    request: Optional[OrbitExtrapolationOutputDto] = None
    __properties: ClassVar[List[str]] = ["computedEvents", "computedMeasurements", "ephemerides", "id", "log", "orbitDataMessageOutput", "orbitalStates", "request"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitExtrapolationResultDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ephemerides (list)
        _items = []
        if self.ephemerides:
            for _item in self.ephemerides:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ephemerides'] = _items
        # override the default output from pydantic by calling `to_dict()` of log
        if self.log:
            _dict['log'] = self.log.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in orbital_states (list)
        _items = []
        if self.orbital_states:
            for _item in self.orbital_states:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orbitalStates'] = _items
        # override the default output from pydantic by calling `to_dict()` of request
        if self.request:
            _dict['request'] = self.request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitExtrapolationResultDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "computedEvents": obj.get("computedEvents"),
            "computedMeasurements": obj.get("computedMeasurements"),
            "ephemerides": [EphemerisDto.from_dict(_item) for _item in obj["ephemerides"]] if obj.get("ephemerides") is not None else None,
            "id": obj.get("id"),
            "log": OrbitExtrapolationLogDto.from_dict(obj["log"]) if obj.get("log") is not None else None,
            "orbitDataMessageOutput": obj.get("orbitDataMessageOutput"),
            "orbitalStates": [OrbitalStateDto.from_dict(_item) for _item in obj["orbitalStates"]] if obj.get("orbitalStates") is not None else None,
            "request": OrbitExtrapolationOutputDto.from_dict(obj["request"]) if obj.get("request") is not None else None
        })
        return _obj


