# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.0.6
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class SmoothedKeplerianElementsDto(BaseModel):
    """
    SmoothedKeplerianElementsDto
    """ # noqa: E501
    argument_of_perigee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="argumentOfPerigee")
    argument_of_perigee_standard_deviation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="argumentOfPerigeeStandardDeviation")
    eccentricity: Optional[Union[StrictFloat, StrictInt]] = None
    eccentricity_standard_deviation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="eccentricityStandardDeviation")
    id: Optional[StrictStr] = None
    inclination: Optional[Union[StrictFloat, StrictInt]] = None
    inclination_standard_deviation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="inclinationStandardDeviation")
    raan: Optional[Union[StrictFloat, StrictInt]] = None
    raan_standard_deviation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="raanStandardDeviation")
    semi_major_axis: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="semiMajorAxis")
    semi_major_axis_standard_deviation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="semiMajorAxisStandardDeviation")
    __properties: ClassVar[List[str]] = ["argumentOfPerigee", "argumentOfPerigeeStandardDeviation", "eccentricity", "eccentricityStandardDeviation", "id", "inclination", "inclinationStandardDeviation", "raan", "raanStandardDeviation", "semiMajorAxis", "semiMajorAxisStandardDeviation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmoothedKeplerianElementsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmoothedKeplerianElementsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "argumentOfPerigee": obj.get("argumentOfPerigee"),
            "argumentOfPerigeeStandardDeviation": obj.get("argumentOfPerigeeStandardDeviation"),
            "eccentricity": obj.get("eccentricity"),
            "eccentricityStandardDeviation": obj.get("eccentricityStandardDeviation"),
            "id": obj.get("id"),
            "inclination": obj.get("inclination"),
            "inclinationStandardDeviation": obj.get("inclinationStandardDeviation"),
            "raan": obj.get("raan"),
            "raanStandardDeviation": obj.get("raanStandardDeviation"),
            "semiMajorAxis": obj.get("semiMajorAxis"),
            "semiMajorAxisStandardDeviation": obj.get("semiMajorAxisStandardDeviation")
        })
        return _obj


