# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.1.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_python_client.models.outlier_manager_settings_dto import OutlierManagerSettingsDto
from typing import Optional, Set
from typing_extensions import Self

class UkfOrbitDeterminationConfigurationDto(BaseModel):
    """
    UkfOrbitDeterminationConfigurationDto
    """ # noqa: E501
    alpha: Union[StrictFloat, StrictInt] = Field(description="Defines the spread of the sigma points. Typical values from 1E-4 to 1E-1")
    beta: Union[StrictFloat, StrictInt] = Field(description="Incorporates knowledge about the distribution of the state vector. Beta = 2 is optimal for Gaussian distributions")
    id: Optional[StrictStr] = None
    kappa: Union[StrictFloat, StrictInt] = Field(description="Secondary scaling parameter. Usually set to 0")
    noise_provider_type: StrictStr = Field(description="Model for the state noise dynamics", alias="noiseProviderType")
    outlier_manager_settings: OutlierManagerSettingsDto = Field(alias="outlierManagerSettings")
    process_noise_matrix_id: StrictStr = Field(description="UUID of the covariance matrix for the state noise distribution", alias="processNoiseMatrixId")
    __properties: ClassVar[List[str]] = ["alpha", "beta", "id", "kappa", "noiseProviderType", "outlierManagerSettings", "processNoiseMatrixId"]

    @field_validator('noise_provider_type')
    def noise_provider_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['BASIC', 'SNC', 'DMC', 'EDB_CD']):
            raise ValueError("must be one of enum values ('BASIC', 'SNC', 'DMC', 'EDB_CD')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UkfOrbitDeterminationConfigurationDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of outlier_manager_settings
        if self.outlier_manager_settings:
            _dict['outlierManagerSettings'] = self.outlier_manager_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UkfOrbitDeterminationConfigurationDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alpha": obj.get("alpha"),
            "beta": obj.get("beta"),
            "id": obj.get("id"),
            "kappa": obj.get("kappa"),
            "noiseProviderType": obj.get("noiseProviderType"),
            "outlierManagerSettings": OutlierManagerSettingsDto.from_dict(obj["outlierManagerSettings"]) if obj.get("outlierManagerSettings") is not None else None,
            "processNoiseMatrixId": obj.get("processNoiseMatrixId")
        })
        return _obj


