# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.1.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class GroundStationDto(BaseModel):
    """
    GroundStationDto
    """ # noqa: E501
    altitude: Union[StrictFloat, StrictInt] = Field(description="Units: [km]")
    elevation_mask: Optional[List[List[Union[StrictFloat, StrictInt]]]] = Field(default=None, description="Units: Double[deg][deg]", alias="elevationMask")
    id: Optional[StrictStr] = None
    latitude: Union[StrictFloat, StrictInt] = Field(description="Units: [deg]")
    longitude: Union[StrictFloat, StrictInt] = Field(description="Units: [deg]")
    min_elevation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units: [deg]", alias="minElevation")
    name: StrictStr
    __properties: ClassVar[List[str]] = ["altitude", "elevationMask", "id", "latitude", "longitude", "minElevation", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GroundStationDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GroundStationDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "altitude": obj.get("altitude"),
            "elevationMask": obj.get("elevationMask"),
            "id": obj.get("id"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "minElevation": obj.get("minElevation"),
            "name": obj.get("name")
        })
        return _obj


