# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.1.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_python_client.models.date_interval_dto import DateIntervalDto
from typing import Optional, Set
from typing_extensions import Self

class ManeuverGenerationInputDto(BaseModel):
    """
    ManeuverGenerationInputDto
    """ # noqa: E501
    delta_eccentricity: Union[StrictFloat, StrictInt] = Field(description="Units: [-]", alias="deltaEccentricity")
    delta_inclination: Union[StrictFloat, StrictInt] = Field(description="Units: [deg]", alias="deltaInclination")
    delta_semi_major_axis: Union[StrictFloat, StrictInt] = Field(description="Units: [km]", alias="deltaSemiMajorAxis")
    initial_orbital_state_id: StrictStr = Field(alias="initialOrbitalStateId")
    maximum_duration: Union[StrictFloat, StrictInt] = Field(description="Units: [s]", alias="maximumDuration")
    no_firing_date_intervals: Optional[List[DateIntervalDto]] = Field(default=None, description="Date intervals where the maneuver is not allowed to be executed", alias="noFiringDateIntervals")
    quaternion_step: Union[StrictFloat, StrictInt] = Field(description="Units: [s]", alias="quaternionStep")
    required_output_orbital_states: Optional[StrictStr] = Field(default=None, alias="requiredOutputOrbitalStates")
    strategy_id: StrictStr = Field(alias="strategyId")
    __properties: ClassVar[List[str]] = ["deltaEccentricity", "deltaInclination", "deltaSemiMajorAxis", "initialOrbitalStateId", "maximumDuration", "noFiringDateIntervals", "quaternionStep", "requiredOutputOrbitalStates", "strategyId"]

    @field_validator('required_output_orbital_states')
    def required_output_orbital_states_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ALL', 'LAST']):
            raise ValueError("must be one of enum values ('ALL', 'LAST')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ManeuverGenerationInputDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in no_firing_date_intervals (list)
        _items = []
        if self.no_firing_date_intervals:
            for _item in self.no_firing_date_intervals:
                if _item:
                    _items.append(_item.to_dict())
            _dict['noFiringDateIntervals'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ManeuverGenerationInputDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deltaEccentricity": obj.get("deltaEccentricity"),
            "deltaInclination": obj.get("deltaInclination"),
            "deltaSemiMajorAxis": obj.get("deltaSemiMajorAxis"),
            "initialOrbitalStateId": obj.get("initialOrbitalStateId"),
            "maximumDuration": obj.get("maximumDuration"),
            "noFiringDateIntervals": [DateIntervalDto.from_dict(_item) for _item in obj["noFiringDateIntervals"]] if obj.get("noFiringDateIntervals") is not None else None,
            "quaternionStep": obj.get("quaternionStep"),
            "requiredOutputOrbitalStates": obj.get("requiredOutputOrbitalStates"),
            "strategyId": obj.get("strategyId")
        })
        return _obj


