# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.1.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_python_client.models.orbital_state_dto import OrbitalStateDto
from typing import Optional, Set
from typing_extensions import Self

class ManeuverGenerationReportDto(BaseModel):
    """
    ManeuverGenerationReportDto
    """ # noqa: E501
    average_thrust_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="averageThrustDuration")
    final_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="finalDutyCycle")
    number_of_period: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="numberOfPeriod")
    orbital_states: Optional[List[OrbitalStateDto]] = Field(default=None, alias="orbitalStates")
    simulation_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="simulationDuration")
    thruster_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="thrusterDutyCycle")
    total_burns_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalBurnsDuration")
    total_consumption: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalConsumption")
    total_delta_v: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalDeltaV")
    total_impulse: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalImpulse")
    total_number_of_burns: Optional[StrictInt] = Field(default=None, alias="totalNumberOfBurns")
    total_warmup_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalWarmupDutyCycle")
    __properties: ClassVar[List[str]] = ["averageThrustDuration", "finalDutyCycle", "numberOfPeriod", "orbitalStates", "simulationDuration", "thrusterDutyCycle", "totalBurnsDuration", "totalConsumption", "totalDeltaV", "totalImpulse", "totalNumberOfBurns", "totalWarmupDutyCycle"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ManeuverGenerationReportDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in orbital_states (list)
        _items = []
        if self.orbital_states:
            for _item in self.orbital_states:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orbitalStates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ManeuverGenerationReportDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "averageThrustDuration": obj.get("averageThrustDuration"),
            "finalDutyCycle": obj.get("finalDutyCycle"),
            "numberOfPeriod": obj.get("numberOfPeriod"),
            "orbitalStates": [OrbitalStateDto.from_dict(_item) for _item in obj["orbitalStates"]] if obj.get("orbitalStates") is not None else None,
            "simulationDuration": obj.get("simulationDuration"),
            "thrusterDutyCycle": obj.get("thrusterDutyCycle"),
            "totalBurnsDuration": obj.get("totalBurnsDuration"),
            "totalConsumption": obj.get("totalConsumption"),
            "totalDeltaV": obj.get("totalDeltaV"),
            "totalImpulse": obj.get("totalImpulse"),
            "totalNumberOfBurns": obj.get("totalNumberOfBurns"),
            "totalWarmupDutyCycle": obj.get("totalWarmupDutyCycle")
        })
        return _obj


