# coding: utf-8

"""
    FDS API

    API for Flight Dynamics System

    The version of the OpenAPI document: 1.1.0
    Contact: contact@exotrail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_python_client.models.tle import TLE
from typing import Optional, Set
from typing_extensions import Self

class OrbitalStateDto(BaseModel):
    """
    OrbitalStateDto
    """ # noqa: E501
    covariance_matrix_id: Optional[StrictStr] = Field(default=None, alias="covarianceMatrixId")
    creation_date: Optional[StrictStr] = Field(default=None, alias="creationDate")
    fitted_tle: Optional[TLE] = Field(default=None, alias="fittedTle")
    id: Optional[StrictStr] = None
    mean_orbit_id: Optional[StrictStr] = Field(default=None, description="Mean orbit data computed with the DSST propagator.", alias="meanOrbitId")
    osculating_orbit_id: Optional[StrictStr] = Field(default=None, alias="osculatingOrbitId")
    propagation_context_id: Optional[StrictStr] = Field(default=None, alias="propagationContextId")
    source: Optional[StrictStr] = None
    spacecraft_id: Optional[StrictStr] = Field(default=None, alias="spacecraftId")
    __properties: ClassVar[List[str]] = ["covarianceMatrixId", "creationDate", "fittedTle", "id", "meanOrbitId", "osculatingOrbitId", "propagationContextId", "source", "spacecraftId"]

    @field_validator('source')
    def source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ORBIT_DETERMINATION', 'ORBIT_EXTRAPOLATION', 'MANUAL', 'MANEUVER_GENERATION']):
            raise ValueError("must be one of enum values ('ORBIT_DETERMINATION', 'ORBIT_EXTRAPOLATION', 'MANUAL', 'MANEUVER_GENERATION')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitalStateDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fitted_tle
        if self.fitted_tle:
            _dict['fittedTle'] = self.fitted_tle.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitalStateDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "covarianceMatrixId": obj.get("covarianceMatrixId"),
            "creationDate": obj.get("creationDate"),
            "fittedTle": TLE.from_dict(obj["fittedTle"]) if obj.get("fittedTle") is not None else None,
            "id": obj.get("id"),
            "meanOrbitId": obj.get("meanOrbitId"),
            "osculatingOrbitId": obj.get("osculatingOrbitId"),
            "propagationContextId": obj.get("propagationContextId"),
            "source": obj.get("source"),
            "spacecraftId": obj.get("spacecraftId")
        })
        return _obj


