import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="SPART-python",
    version="1.0.4",
    author="G. Worrall",
    author_email="worrall.george@gmail.com",
    description="Python implementation of the SPART optical radiative transfer model.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/wirrell/SPART-python",
    packages=setuptools.find_packages(),
    package_data={
        'SPART': ['model_parameters/*.pkl', 'sensor_information/*.pkl']
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Operating System :: OS Independent",
        "Topic :: Scientific/Engineering :: GIS"
    ],
    python_requires='>=3.4',
)
