# coding: utf-8

"""
    Spartera API Documentation

    Auto-generated API documentation for REST services of the Spartera platform

    The version of the OpenAPI document: 0.0.0
    Contact: support@spartera.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Assetpricehistory(BaseModel):
    """
    Pricing history for an asset
    """ # noqa: E501
    aph_id: Optional[StrictStr] = None
    asset_id: StrictStr
    price_usd: Optional[Union[StrictFloat, StrictInt]] = None
    price_credits: Optional[StrictStr] = None
    discount_percentage: Optional[Union[StrictFloat, StrictInt]] = None
    sale_start_date: Optional[StrictStr] = None
    sale_end_date: Optional[StrictStr] = None
    date_ended: Optional[StrictStr] = None
    date_created: Optional[StrictStr] = None
    last_updated: Optional[StrictStr] = None
    active: StrictStr
    __properties: ClassVar[List[str]] = ["aph_id", "asset_id", "price_usd", "price_credits", "discount_percentage", "sale_start_date", "sale_end_date", "date_ended", "date_created", "last_updated", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Assetpricehistory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "date_created",
            "last_updated",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Assetpricehistory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aph_id": obj.get("aph_id"),
            "asset_id": obj.get("asset_id"),
            "price_usd": obj.get("price_usd"),
            "price_credits": obj.get("price_credits"),
            "discount_percentage": obj.get("discount_percentage"),
            "sale_start_date": obj.get("sale_start_date"),
            "sale_end_date": obj.get("sale_end_date"),
            "date_ended": obj.get("date_ended"),
            "date_created": obj.get("date_created"),
            "last_updated": obj.get("last_updated"),
            "active": obj.get("active")
        })
        return _obj


