# coding: utf-8

"""
    Spartera API Documentation

    Auto-generated API documentation for REST services of the Spartera platform

    The version of the OpenAPI document: 0.0.0
    Contact: support@spartera.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from spartera_api_sdk.models.me_get200_response_api_key_info import MeGet200ResponseApiKeyInfo
from spartera_api_sdk.models.me_get200_response_profile import MeGet200ResponseProfile
from spartera_api_sdk.models.me_get200_response_token_metadata import MeGet200ResponseTokenMetadata
from typing import Optional, Set
from typing_extensions import Self

class MeGet200Response(BaseModel):
    """
    MeGet200Response
    """ # noqa: E501
    user_id: StrictStr = Field(description="Firebase user ID")
    email: Optional[StrictStr] = Field(default=None, description="User email address")
    auth_method: StrictStr = Field(description="Authentication method used")
    platform: Optional[StrictStr] = Field(default=None, description="Platform origin")
    origin_domain: Optional[StrictStr] = Field(default=None, description="Request origin domain")
    profile: MeGet200ResponseProfile
    company_id: StrictStr = Field(description="Company ID from authentication claims")
    role_id: StrictInt = Field(description="Role ID from authentication claims")
    token_metadata: Optional[MeGet200ResponseTokenMetadata] = None
    api_key_info: Optional[MeGet200ResponseApiKeyInfo] = None
    __properties: ClassVar[List[str]] = ["user_id", "email", "auth_method", "platform", "origin_domain", "profile", "company_id", "role_id", "token_metadata", "api_key_info"]

    @field_validator('auth_method')
    def auth_method_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['jwt_token', 'api_key']):
            raise ValueError("must be one of enum values ('jwt_token', 'api_key')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of token_metadata
        if self.token_metadata:
            _dict['token_metadata'] = self.token_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of api_key_info
        if self.api_key_info:
            _dict['api_key_info'] = self.api_key_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "email": obj.get("email"),
            "auth_method": obj.get("auth_method"),
            "platform": obj.get("platform"),
            "origin_domain": obj.get("origin_domain"),
            "profile": MeGet200ResponseProfile.from_dict(obj["profile"]) if obj.get("profile") is not None else None,
            "company_id": obj.get("company_id"),
            "role_id": obj.get("role_id"),
            "token_metadata": MeGet200ResponseTokenMetadata.from_dict(obj["token_metadata"]) if obj.get("token_metadata") is not None else None,
            "api_key_info": MeGet200ResponseApiKeyInfo.from_dict(obj["api_key_info"]) if obj.get("api_key_info") is not None else None
        })
        return _obj


