# coding: utf-8

"""
    Spartera API Documentation

    Auto-generated API documentation for REST services of the Spartera platform

    The version of the OpenAPI document: 0.0.0
    Contact: support@spartera.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MeGet200ResponseProfile(BaseModel):
    """
    MeGet200ResponseProfile
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="User ID (primary key)")
    type: Optional[StrictStr] = Field(default=None, description="Profile type")
    company_id: Optional[StrictStr] = Field(default=None, description="Company ID")
    function_id: Optional[StrictInt] = Field(default=None, description="User function/role ID")
    status: Optional[StrictStr] = Field(default=None, description="User status")
    email_address: Optional[StrictStr] = Field(default=None, description="User email address")
    timezone: Optional[StrictStr] = Field(default=None, description="User timezone")
    date_created: Optional[datetime] = Field(default=None, description="Account creation date")
    last_updated: Optional[datetime] = Field(default=None, description="Last profile update")
    active: Optional[StrictBool] = Field(default=None, description="Account active status")
    __properties: ClassVar[List[str]] = ["id", "type", "company_id", "function_id", "status", "email_address", "timezone", "date_created", "last_updated", "active"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['human_user', 'service_account']):
            raise ValueError("must be one of enum values ('human_user', 'service_account')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeGet200ResponseProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeGet200ResponseProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "company_id": obj.get("company_id"),
            "function_id": obj.get("function_id"),
            "status": obj.get("status"),
            "email_address": obj.get("email_address"),
            "timezone": obj.get("timezone"),
            "date_created": obj.get("date_created"),
            "last_updated": obj.get("last_updated"),
            "active": obj.get("active")
        })
        return _obj


