# coding: utf-8

"""
    Spartera API Documentation

    Auto-generated API documentation for REST services of the Spartera platform

    The version of the OpenAPI document: 0.0.0
    Contact: support@spartera.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Connection(BaseModel):
    """
    Model for every connection setup from our platform
    """ # noqa: E501
    connection_id: Optional[StrictStr] = None
    user_id: Optional[StrictStr] = None
    engine_id: StrictStr
    company_id: StrictStr
    credential_type: Optional[StrictStr] = None
    api_provider: Optional[StrictStr] = None
    api_endpoint: Optional[StrictStr] = None
    api_key_location: Optional[StrictStr] = None
    api_key_param: Optional[StrictStr] = None
    api_key_value: Optional[StrictStr] = None
    visibility: StrictStr
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    gcp_secret_id: Optional[StrictStr] = None
    provider_domain: Optional[StrictStr] = None
    verified_usage_ability: Optional[StrictStr] = None
    date_created: Optional[StrictStr] = None
    last_updated: Optional[StrictStr] = None
    active: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["connection_id", "user_id", "engine_id", "company_id", "credential_type", "api_provider", "api_endpoint", "api_key_location", "api_key_param", "api_key_value", "visibility", "name", "description", "gcp_secret_id", "provider_domain", "verified_usage_ability", "date_created", "last_updated", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Connection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Connection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "connection_id": obj.get("connection_id"),
            "user_id": obj.get("user_id"),
            "engine_id": obj.get("engine_id"),
            "company_id": obj.get("company_id"),
            "credential_type": obj.get("credential_type"),
            "api_provider": obj.get("api_provider"),
            "api_endpoint": obj.get("api_endpoint"),
            "api_key_location": obj.get("api_key_location"),
            "api_key_param": obj.get("api_key_param"),
            "api_key_value": obj.get("api_key_value"),
            "visibility": obj.get("visibility"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "gcp_secret_id": obj.get("gcp_secret_id"),
            "provider_domain": obj.get("provider_domain"),
            "verified_usage_ability": obj.get("verified_usage_ability"),
            "date_created": obj.get("date_created"),
            "last_updated": obj.get("last_updated"),
            "active": obj.get("active")
        })
        return _obj


