# coding: utf-8

"""
    Spartera API Documentation

    Auto-generated API documentation for REST services of the Spartera platform

    The version of the OpenAPI document: 1.24.0
    Contact: support@spartera.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Companies(BaseModel):
    """
    All of our customer company entities
    """ # noqa: E501
    date_created: Optional[datetime] = None
    last_updated: Optional[datetime] = None
    company_id: Optional[StrictStr] = None
    industry_id: Optional[StrictInt] = None
    country_id: Optional[StrictInt] = None
    company_name: Optional[StrictStr] = None
    company_description: Optional[StrictStr] = None
    company_handle: StrictStr
    company_domain: StrictStr
    credits_balance: StrictInt = Field(description="Current balance of credits for this company (buyer)")
    accepted_eula: Optional[StrictBool] = None
    stripe_account_id: Optional[StrictStr] = Field(default=None, description="Stripe Connect account ID for marketplace sellers")
    stripe_account_status: Optional[StrictStr] = Field(default=None, description="Status of the Stripe account (verified, pending, etc.)")
    __properties: ClassVar[List[str]] = ["date_created", "last_updated", "company_id", "industry_id", "country_id", "company_name", "company_description", "company_handle", "company_domain", "credits_balance", "accepted_eula", "stripe_account_id", "stripe_account_status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Companies from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Companies from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date_created": obj.get("date_created"),
            "last_updated": obj.get("last_updated"),
            "company_id": obj.get("company_id"),
            "industry_id": obj.get("industry_id"),
            "country_id": obj.get("country_id"),
            "company_name": obj.get("company_name"),
            "company_description": obj.get("company_description"),
            "company_handle": obj.get("company_handle"),
            "company_domain": obj.get("company_domain"),
            "credits_balance": obj.get("credits_balance"),
            "accepted_eula": obj.get("accepted_eula"),
            "stripe_account_id": obj.get("stripe_account_id"),
            "stripe_account_status": obj.get("stripe_account_status")
        })
        return _obj


