# coding: utf-8

"""
    Spartera API Documentation

    Auto-generated API documentation for REST services of the Spartera platform

    The version of the OpenAPI document: 1.24.0
    Contact: support@spartera.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Users(BaseModel):
    """
    Individual users within a company with SOC2 authentication tracking
    """ # noqa: E501
    date_created: Optional[datetime] = None
    last_updated: Optional[datetime] = None
    user_id: Optional[StrictStr] = None
    company_id: StrictStr
    function_id: Optional[StrictInt] = None
    status: StrictStr = Field(description="Enum type: StatusCodes")
    email_address: Optional[StrictStr] = None
    timezone: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["date_created", "last_updated", "user_id", "company_id", "function_id", "status", "email_address", "timezone"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ACTIVE', 'PENDING', 'INACTIVE', 'BANNED']):
            raise ValueError("must be one of enum values ('ACTIVE', 'PENDING', 'INACTIVE', 'BANNED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Users from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Users from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date_created": obj.get("date_created"),
            "last_updated": obj.get("last_updated"),
            "user_id": obj.get("user_id"),
            "company_id": obj.get("company_id"),
            "function_id": obj.get("function_id"),
            "status": obj.get("status"),
            "email_address": obj.get("email_address"),
            "timezone": obj.get("timezone")
        })
        return _obj


